/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.Mqtt5Configuration;
import software.amazon.awssdk.services.iot.model.SearchableAttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThingTypeProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThingTypeProperties> {
    private static final SdkField<String> THING_TYPE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingTypeDescription").getter(ThingTypeProperties.getter(ThingTypeProperties::thingTypeDescription)).setter(ThingTypeProperties.setter(Builder::thingTypeDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeDescription").build()}).build();
    private static final SdkField<List<String>> SEARCHABLE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("searchableAttributes").getter(ThingTypeProperties.getter(ThingTypeProperties::searchableAttributes)).setter(ThingTypeProperties.setter(Builder::searchableAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchableAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Mqtt5Configuration> MQTT5_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("mqtt5Configuration").getter(ThingTypeProperties.getter(ThingTypeProperties::mqtt5Configuration)).setter(ThingTypeProperties.setter(Builder::mqtt5Configuration)).constructor(Mqtt5Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mqtt5Configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_TYPE_DESCRIPTION_FIELD, SEARCHABLE_ATTRIBUTES_FIELD, MQTT5_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("thingTypeDescription", THING_TYPE_DESCRIPTION_FIELD);
            this.put("searchableAttributes", SEARCHABLE_ATTRIBUTES_FIELD);
            this.put("mqtt5Configuration", MQTT5_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String thingTypeDescription;
    private final List<String> searchableAttributes;
    private final Mqtt5Configuration mqtt5Configuration;

    private ThingTypeProperties(BuilderImpl builder) {
        this.thingTypeDescription = builder.thingTypeDescription;
        this.searchableAttributes = builder.searchableAttributes;
        this.mqtt5Configuration = builder.mqtt5Configuration;
    }

    public final String thingTypeDescription() {
        return this.thingTypeDescription;
    }

    public final boolean hasSearchableAttributes() {
        return this.searchableAttributes != null && !(this.searchableAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> searchableAttributes() {
        return this.searchableAttributes;
    }

    public final Mqtt5Configuration mqtt5Configuration() {
        return this.mqtt5Configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSearchableAttributes() ? this.searchableAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mqtt5Configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingTypeProperties)) {
            return false;
        }
        ThingTypeProperties other = (ThingTypeProperties)obj;
        return Objects.equals(this.thingTypeDescription(), other.thingTypeDescription()) && this.hasSearchableAttributes() == other.hasSearchableAttributes() && Objects.equals(this.searchableAttributes(), other.searchableAttributes()) && Objects.equals(this.mqtt5Configuration(), other.mqtt5Configuration());
    }

    public final String toString() {
        return ToString.builder((String)"ThingTypeProperties").add("ThingTypeDescription", (Object)this.thingTypeDescription()).add("SearchableAttributes", this.hasSearchableAttributes() ? this.searchableAttributes() : null).add("Mqtt5Configuration", (Object)this.mqtt5Configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingTypeDescription": {
                return Optional.ofNullable(clazz.cast(this.thingTypeDescription()));
            }
            case "searchableAttributes": {
                return Optional.ofNullable(clazz.cast(this.searchableAttributes()));
            }
            case "mqtt5Configuration": {
                return Optional.ofNullable(clazz.cast(this.mqtt5Configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ThingTypeProperties, T> g) {
        return obj -> g.apply((ThingTypeProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingTypeDescription;
        private List<String> searchableAttributes = DefaultSdkAutoConstructList.getInstance();
        private Mqtt5Configuration mqtt5Configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingTypeProperties model) {
            this.thingTypeDescription(model.thingTypeDescription);
            this.searchableAttributes(model.searchableAttributes);
            this.mqtt5Configuration(model.mqtt5Configuration);
        }

        public final String getThingTypeDescription() {
            return this.thingTypeDescription;
        }

        public final void setThingTypeDescription(String thingTypeDescription) {
            this.thingTypeDescription = thingTypeDescription;
        }

        @Override
        public final Builder thingTypeDescription(String thingTypeDescription) {
            this.thingTypeDescription = thingTypeDescription;
            return this;
        }

        public final Collection<String> getSearchableAttributes() {
            if (this.searchableAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.searchableAttributes;
        }

        public final void setSearchableAttributes(Collection<String> searchableAttributes) {
            this.searchableAttributes = SearchableAttributesCopier.copy(searchableAttributes);
        }

        @Override
        public final Builder searchableAttributes(Collection<String> searchableAttributes) {
            this.searchableAttributes = SearchableAttributesCopier.copy(searchableAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchableAttributes(String ... searchableAttributes) {
            this.searchableAttributes(Arrays.asList(searchableAttributes));
            return this;
        }

        public final Mqtt5Configuration.Builder getMqtt5Configuration() {
            return this.mqtt5Configuration != null ? this.mqtt5Configuration.toBuilder() : null;
        }

        public final void setMqtt5Configuration(Mqtt5Configuration.BuilderImpl mqtt5Configuration) {
            this.mqtt5Configuration = mqtt5Configuration != null ? mqtt5Configuration.build() : null;
        }

        @Override
        public final Builder mqtt5Configuration(Mqtt5Configuration mqtt5Configuration) {
            this.mqtt5Configuration = mqtt5Configuration;
            return this;
        }

        public ThingTypeProperties build() {
            return new ThingTypeProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThingTypeProperties> {
        public Builder thingTypeDescription(String var1);

        public Builder searchableAttributes(Collection<String> var1);

        public Builder searchableAttributes(String ... var1);

        public Builder mqtt5Configuration(Mqtt5Configuration var1);

        default public Builder mqtt5Configuration(Consumer<Mqtt5Configuration.Builder> mqtt5Configuration) {
            return this.mqtt5Configuration((Mqtt5Configuration)((Mqtt5Configuration.Builder)Mqtt5Configuration.builder().applyMutation(mqtt5Configuration)).build());
        }
    }
}

