/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListViolationEventsRequest;
import software.amazon.awssdk.services.iot.model.ListViolationEventsResponse;
import software.amazon.awssdk.services.iot.model.ViolationEvent;

public class ListViolationEventsPublisher
implements SdkPublisher<ListViolationEventsResponse> {
    private final IotAsyncClient client;
    private final ListViolationEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListViolationEventsPublisher(IotAsyncClient client, ListViolationEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListViolationEventsPublisher(IotAsyncClient client, ListViolationEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListViolationEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListViolationEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ViolationEvent> violationEvents() {
        Function<ListViolationEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.violationEvents() != null) {
                return response.violationEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListViolationEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListViolationEventsResponseFetcher
    implements AsyncPageFetcher<ListViolationEventsResponse> {
        private ListViolationEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListViolationEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListViolationEventsResponse> nextPage(ListViolationEventsResponse previousPage) {
            if (previousPage == null) {
                return ListViolationEventsPublisher.this.client.listViolationEvents(ListViolationEventsPublisher.this.firstRequest);
            }
            return ListViolationEventsPublisher.this.client.listViolationEvents((ListViolationEventsRequest)((Object)ListViolationEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

