/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.CommandSummary;
import software.amazon.awssdk.services.iot.model.CommandSummaryListCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCommandsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListCommandsResponse> {
    private static final SdkField<List<CommandSummary>> COMMANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("commands").getter(ListCommandsResponse.getter(ListCommandsResponse::commands)).setter(ListCommandsResponse.setter(Builder::commands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CommandSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCommandsResponse.getter(ListCommandsResponse::nextToken)).setter(ListCommandsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMANDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("commands", COMMANDS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<CommandSummary> commands;
    private final String nextToken;

    private ListCommandsResponse(BuilderImpl builder) {
        super(builder);
        this.commands = builder.commands;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCommands() {
        return this.commands != null && !(this.commands instanceof SdkAutoConstructList);
    }

    public final List<CommandSummary> commands() {
        return this.commands;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommands() ? this.commands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandsResponse)) {
            return false;
        }
        ListCommandsResponse other = (ListCommandsResponse)((Object)obj);
        return this.hasCommands() == other.hasCommands() && Objects.equals(this.commands(), other.commands()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCommandsResponse").add("Commands", this.hasCommands() ? this.commands() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commands": {
                return Optional.ofNullable(clazz.cast(this.commands()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCommandsResponse, T> g) {
        return obj -> g.apply((ListCommandsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<CommandSummary> commands = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandsResponse model) {
            super(model);
            this.commands(model.commands);
            this.nextToken(model.nextToken);
        }

        public final List<CommandSummary.Builder> getCommands() {
            List<CommandSummary.Builder> result = CommandSummaryListCopier.copyToBuilder(this.commands);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommands(Collection<CommandSummary.BuilderImpl> commands) {
            this.commands = CommandSummaryListCopier.copyFromBuilder(commands);
        }

        @Override
        public final Builder commands(Collection<CommandSummary> commands) {
            this.commands = CommandSummaryListCopier.copy(commands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(CommandSummary ... commands) {
            this.commands(Arrays.asList(commands));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(Consumer<CommandSummary.Builder> ... commands) {
            this.commands(Stream.of(commands).map(c -> (CommandSummary)((CommandSummary.Builder)CommandSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCommandsResponse build() {
            return new ListCommandsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCommandsResponse> {
        public Builder commands(Collection<CommandSummary> var1);

        public Builder commands(CommandSummary ... var1);

        public Builder commands(Consumer<CommandSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

