/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.LogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLoggingOptionsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, GetLoggingOptionsResponse> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetLoggingOptionsResponse.getter(GetLoggingOptionsResponse::roleArn)).setter(GetLoggingOptionsResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logLevel").getter(GetLoggingOptionsResponse.getter(GetLoggingOptionsResponse::logLevelAsString)).setter(GetLoggingOptionsResponse.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, LOG_LEVEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("logLevel", LOG_LEVEL_FIELD);
        }
    });
    private final String roleArn;
    private final String logLevel;

    private GetLoggingOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.logLevel = builder.logLevel;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoggingOptionsResponse)) {
            return false;
        }
        GetLoggingOptionsResponse other = (GetLoggingOptionsResponse)((Object)obj);
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetLoggingOptionsResponse").add("RoleArn", (Object)this.roleArn()).add("LogLevel", (Object)this.logLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "logLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetLoggingOptionsResponse, T> g) {
        return obj -> g.apply((GetLoggingOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String roleArn;
        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoggingOptionsResponse model) {
            super(model);
            this.roleArn(model.roleArn);
            this.logLevel(model.logLevel);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        @Override
        public GetLoggingOptionsResponse build() {
            return new GetLoggingOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLoggingOptionsResponse> {
        public Builder roleArn(String var1);

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);
    }
}

