/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.CommandSummary;
import software.amazon.awssdk.services.iot.model.ListCommandsRequest;
import software.amazon.awssdk.services.iot.model.ListCommandsResponse;

public class ListCommandsIterable
implements SdkIterable<ListCommandsResponse> {
    private final IotClient client;
    private final ListCommandsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCommandsIterable(IotClient client, ListCommandsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCommandsResponseFetcher();
    }

    public Iterator<ListCommandsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CommandSummary> commands() {
        Function<ListCommandsResponse, Iterator> getIterator = response -> {
            if (response != null && response.commands() != null) {
                return response.commands().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCommandsResponseFetcher
    implements SyncPageFetcher<ListCommandsResponse> {
        private ListCommandsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommandsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCommandsResponse nextPage(ListCommandsResponse previousPage) {
            if (previousPage == null) {
                return ListCommandsIterable.this.client.listCommands(ListCommandsIterable.this.firstRequest);
            }
            return ListCommandsIterable.this.client.listCommands((ListCommandsRequest)((Object)ListCommandsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

