/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.AuditFrequency;
import software.amazon.awssdk.services.iot.model.DayOfWeek;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledAuditMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledAuditMetadata> {
    private static final SdkField<String> SCHEDULED_AUDIT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scheduledAuditName").getter(ScheduledAuditMetadata.getter(ScheduledAuditMetadata::scheduledAuditName)).setter(ScheduledAuditMetadata.setter(Builder::scheduledAuditName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledAuditName").build()}).build();
    private static final SdkField<String> SCHEDULED_AUDIT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scheduledAuditArn").getter(ScheduledAuditMetadata.getter(ScheduledAuditMetadata::scheduledAuditArn)).setter(ScheduledAuditMetadata.setter(Builder::scheduledAuditArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledAuditArn").build()}).build();
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frequency").getter(ScheduledAuditMetadata.getter(ScheduledAuditMetadata::frequencyAsString)).setter(ScheduledAuditMetadata.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()}).build();
    private static final SdkField<String> DAY_OF_MONTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dayOfMonth").getter(ScheduledAuditMetadata.getter(ScheduledAuditMetadata::dayOfMonth)).setter(ScheduledAuditMetadata.setter(Builder::dayOfMonth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dayOfMonth").build()}).build();
    private static final SdkField<String> DAY_OF_WEEK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dayOfWeek").getter(ScheduledAuditMetadata.getter(ScheduledAuditMetadata::dayOfWeekAsString)).setter(ScheduledAuditMetadata.setter(Builder::dayOfWeek)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dayOfWeek").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_AUDIT_NAME_FIELD, SCHEDULED_AUDIT_ARN_FIELD, FREQUENCY_FIELD, DAY_OF_MONTH_FIELD, DAY_OF_WEEK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("scheduledAuditName", SCHEDULED_AUDIT_NAME_FIELD);
            this.put("scheduledAuditArn", SCHEDULED_AUDIT_ARN_FIELD);
            this.put("frequency", FREQUENCY_FIELD);
            this.put("dayOfMonth", DAY_OF_MONTH_FIELD);
            this.put("dayOfWeek", DAY_OF_WEEK_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String scheduledAuditName;
    private final String scheduledAuditArn;
    private final String frequency;
    private final String dayOfMonth;
    private final String dayOfWeek;

    private ScheduledAuditMetadata(BuilderImpl builder) {
        this.scheduledAuditName = builder.scheduledAuditName;
        this.scheduledAuditArn = builder.scheduledAuditArn;
        this.frequency = builder.frequency;
        this.dayOfMonth = builder.dayOfMonth;
        this.dayOfWeek = builder.dayOfWeek;
    }

    public final String scheduledAuditName() {
        return this.scheduledAuditName;
    }

    public final String scheduledAuditArn() {
        return this.scheduledAuditArn;
    }

    public final AuditFrequency frequency() {
        return AuditFrequency.fromValue(this.frequency);
    }

    public final String frequencyAsString() {
        return this.frequency;
    }

    public final String dayOfMonth() {
        return this.dayOfMonth;
    }

    public final DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(this.dayOfWeek);
    }

    public final String dayOfWeekAsString() {
        return this.dayOfWeek;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledAuditName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledAuditArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfWeekAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledAuditMetadata)) {
            return false;
        }
        ScheduledAuditMetadata other = (ScheduledAuditMetadata)obj;
        return Objects.equals(this.scheduledAuditName(), other.scheduledAuditName()) && Objects.equals(this.scheduledAuditArn(), other.scheduledAuditArn()) && Objects.equals(this.frequencyAsString(), other.frequencyAsString()) && Objects.equals(this.dayOfMonth(), other.dayOfMonth()) && Objects.equals(this.dayOfWeekAsString(), other.dayOfWeekAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledAuditMetadata").add("ScheduledAuditName", (Object)this.scheduledAuditName()).add("ScheduledAuditArn", (Object)this.scheduledAuditArn()).add("Frequency", (Object)this.frequencyAsString()).add("DayOfMonth", (Object)this.dayOfMonth()).add("DayOfWeek", (Object)this.dayOfWeekAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scheduledAuditName": {
                return Optional.ofNullable(clazz.cast(this.scheduledAuditName()));
            }
            case "scheduledAuditArn": {
                return Optional.ofNullable(clazz.cast(this.scheduledAuditArn()));
            }
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
            case "dayOfMonth": {
                return Optional.ofNullable(clazz.cast(this.dayOfMonth()));
            }
            case "dayOfWeek": {
                return Optional.ofNullable(clazz.cast(this.dayOfWeekAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledAuditMetadata, T> g) {
        return obj -> g.apply((ScheduledAuditMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scheduledAuditName;
        private String scheduledAuditArn;
        private String frequency;
        private String dayOfMonth;
        private String dayOfWeek;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledAuditMetadata model) {
            this.scheduledAuditName(model.scheduledAuditName);
            this.scheduledAuditArn(model.scheduledAuditArn);
            this.frequency(model.frequency);
            this.dayOfMonth(model.dayOfMonth);
            this.dayOfWeek(model.dayOfWeek);
        }

        public final String getScheduledAuditName() {
            return this.scheduledAuditName;
        }

        public final void setScheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
        }

        @Override
        public final Builder scheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
            return this;
        }

        public final String getScheduledAuditArn() {
            return this.scheduledAuditArn;
        }

        public final void setScheduledAuditArn(String scheduledAuditArn) {
            this.scheduledAuditArn = scheduledAuditArn;
        }

        @Override
        public final Builder scheduledAuditArn(String scheduledAuditArn) {
            this.scheduledAuditArn = scheduledAuditArn;
            return this;
        }

        public final String getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(AuditFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public final String getDayOfMonth() {
            return this.dayOfMonth;
        }

        public final void setDayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final String getDayOfWeek() {
            return this.dayOfWeek;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek == null ? null : dayOfWeek.toString());
            return this;
        }

        public ScheduledAuditMetadata build() {
            return new ScheduledAuditMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledAuditMetadata> {
        public Builder scheduledAuditName(String var1);

        public Builder scheduledAuditArn(String var1);

        public Builder frequency(String var1);

        public Builder frequency(AuditFrequency var1);

        public Builder dayOfMonth(String var1);

        public Builder dayOfWeek(String var1);

        public Builder dayOfWeek(DayOfWeek var1);
    }
}

