/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.JobStatus;
import software.amazon.awssdk.services.iot.model.TargetSelection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobsRequest
extends IotRequest
implements ToCopyableBuilder<Builder, ListJobsRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListJobsRequest.getter(ListJobsRequest::statusAsString)).setter(ListJobsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final SdkField<String> TARGET_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetSelection").getter(ListJobsRequest.getter(ListJobsRequest::targetSelectionAsString)).setter(ListJobsRequest.setter(Builder::targetSelection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetSelection").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListJobsRequest.getter(ListJobsRequest::maxResults)).setter(ListJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListJobsRequest.getter(ListJobsRequest::nextToken)).setter(ListJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> THING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingGroupName").getter(ListJobsRequest.getter(ListJobsRequest::thingGroupName)).setter(ListJobsRequest.setter(Builder::thingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("thingGroupName").build()}).build();
    private static final SdkField<String> THING_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingGroupId").getter(ListJobsRequest.getter(ListJobsRequest::thingGroupId)).setter(ListJobsRequest.setter(Builder::thingGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("thingGroupId").build()}).build();
    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceId").getter(ListJobsRequest.getter(ListJobsRequest::namespaceId)).setter(ListJobsRequest.setter(Builder::namespaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, TARGET_SELECTION_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, THING_GROUP_NAME_FIELD, THING_GROUP_ID_FIELD, NAMESPACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("status", STATUS_FIELD);
            this.put("targetSelection", TARGET_SELECTION_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("thingGroupName", THING_GROUP_NAME_FIELD);
            this.put("thingGroupId", THING_GROUP_ID_FIELD);
            this.put("namespaceId", NAMESPACE_ID_FIELD);
        }
    });
    private final String status;
    private final String targetSelection;
    private final Integer maxResults;
    private final String nextToken;
    private final String thingGroupName;
    private final String thingGroupId;
    private final String namespaceId;

    private ListJobsRequest(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.targetSelection = builder.targetSelection;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupId = builder.thingGroupId;
        this.namespaceId = builder.namespaceId;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final TargetSelection targetSelection() {
        return TargetSelection.fromValue(this.targetSelection);
    }

    public final String targetSelectionAsString() {
        return this.targetSelection;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String thingGroupName() {
        return this.thingGroupName;
    }

    public final String thingGroupId() {
        return this.thingGroupId;
    }

    public final String namespaceId() {
        return this.namespaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsRequest)) {
            return false;
        }
        ListJobsRequest other = (ListJobsRequest)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targetSelectionAsString(), other.targetSelectionAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.thingGroupName(), other.thingGroupName()) && Objects.equals(this.thingGroupId(), other.thingGroupId()) && Objects.equals(this.namespaceId(), other.namespaceId());
    }

    public final String toString() {
        return ToString.builder((String)"ListJobsRequest").add("Status", (Object)this.statusAsString()).add("TargetSelection", (Object)this.targetSelectionAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ThingGroupName", (Object)this.thingGroupName()).add("ThingGroupId", (Object)this.thingGroupId()).add("NamespaceId", (Object)this.namespaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "targetSelection": {
                return Optional.ofNullable(clazz.cast(this.targetSelectionAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "thingGroupName": {
                return Optional.ofNullable(clazz.cast(this.thingGroupName()));
            }
            case "thingGroupId": {
                return Optional.ofNullable(clazz.cast(this.thingGroupId()));
            }
            case "namespaceId": {
                return Optional.ofNullable(clazz.cast(this.namespaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsRequest, T> g) {
        return obj -> g.apply((ListJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String status;
        private String targetSelection;
        private Integer maxResults;
        private String nextToken;
        private String thingGroupName;
        private String thingGroupId;
        private String namespaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsRequest model) {
            super(model);
            this.status(model.status);
            this.targetSelection(model.targetSelection);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.thingGroupName(model.thingGroupName);
            this.thingGroupId(model.thingGroupId);
            this.namespaceId(model.namespaceId);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTargetSelection() {
            return this.targetSelection;
        }

        public final void setTargetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
        }

        @Override
        public final Builder targetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
            return this;
        }

        @Override
        public final Builder targetSelection(TargetSelection targetSelection) {
            this.targetSelection(targetSelection == null ? null : targetSelection.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getThingGroupName() {
            return this.thingGroupName;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final String getThingGroupId() {
            return this.thingGroupId;
        }

        public final void setThingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
        }

        @Override
        public final Builder thingGroupId(String thingGroupId) {
            this.thingGroupId = thingGroupId;
            return this;
        }

        public final String getNamespaceId() {
            return this.namespaceId;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        @Override
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobsRequest build() {
            return new ListJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobsRequest> {
        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder targetSelection(String var1);

        public Builder targetSelection(TargetSelection var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder thingGroupName(String var1);

        public Builder thingGroupId(String var1);

        public Builder namespaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

