/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AuthorizerStatus;
import software.amazon.awssdk.services.iot.model.PublicKeyMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizerDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthorizerDescription> {
    private static final SdkField<String> AUTHORIZER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizerName").getter(AuthorizerDescription.getter(AuthorizerDescription::authorizerName)).setter(AuthorizerDescription.setter(Builder::authorizerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerName").build()}).build();
    private static final SdkField<String> AUTHORIZER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizerArn").getter(AuthorizerDescription.getter(AuthorizerDescription::authorizerArn)).setter(AuthorizerDescription.setter(Builder::authorizerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerArn").build()}).build();
    private static final SdkField<String> AUTHORIZER_FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizerFunctionArn").getter(AuthorizerDescription.getter(AuthorizerDescription::authorizerFunctionArn)).setter(AuthorizerDescription.setter(Builder::authorizerFunctionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerFunctionArn").build()}).build();
    private static final SdkField<String> TOKEN_KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenKeyName").getter(AuthorizerDescription.getter(AuthorizerDescription::tokenKeyName)).setter(AuthorizerDescription.setter(Builder::tokenKeyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenKeyName").build()}).build();
    private static final SdkField<Map<String, String>> TOKEN_SIGNING_PUBLIC_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tokenSigningPublicKeys").getter(AuthorizerDescription.getter(AuthorizerDescription::tokenSigningPublicKeys)).setter(AuthorizerDescription.setter(Builder::tokenSigningPublicKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenSigningPublicKeys").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AuthorizerDescription.getter(AuthorizerDescription::statusAsString)).setter(AuthorizerDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(AuthorizerDescription.getter(AuthorizerDescription::creationDate)).setter(AuthorizerDescription.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(AuthorizerDescription.getter(AuthorizerDescription::lastModifiedDate)).setter(AuthorizerDescription.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final SdkField<Boolean> SIGNING_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("signingDisabled").getter(AuthorizerDescription.getter(AuthorizerDescription::signingDisabled)).setter(AuthorizerDescription.setter(Builder::signingDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingDisabled").build()}).build();
    private static final SdkField<Boolean> ENABLE_CACHING_FOR_HTTP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableCachingForHttp").getter(AuthorizerDescription.getter(AuthorizerDescription::enableCachingForHttp)).setter(AuthorizerDescription.setter(Builder::enableCachingForHttp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableCachingForHttp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZER_NAME_FIELD, AUTHORIZER_ARN_FIELD, AUTHORIZER_FUNCTION_ARN_FIELD, TOKEN_KEY_NAME_FIELD, TOKEN_SIGNING_PUBLIC_KEYS_FIELD, STATUS_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, SIGNING_DISABLED_FIELD, ENABLE_CACHING_FOR_HTTP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String authorizerName;
    private final String authorizerArn;
    private final String authorizerFunctionArn;
    private final String tokenKeyName;
    private final Map<String, String> tokenSigningPublicKeys;
    private final String status;
    private final Instant creationDate;
    private final Instant lastModifiedDate;
    private final Boolean signingDisabled;
    private final Boolean enableCachingForHttp;

    private AuthorizerDescription(BuilderImpl builder) {
        this.authorizerName = builder.authorizerName;
        this.authorizerArn = builder.authorizerArn;
        this.authorizerFunctionArn = builder.authorizerFunctionArn;
        this.tokenKeyName = builder.tokenKeyName;
        this.tokenSigningPublicKeys = builder.tokenSigningPublicKeys;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.signingDisabled = builder.signingDisabled;
        this.enableCachingForHttp = builder.enableCachingForHttp;
    }

    public final String authorizerName() {
        return this.authorizerName;
    }

    public final String authorizerArn() {
        return this.authorizerArn;
    }

    public final String authorizerFunctionArn() {
        return this.authorizerFunctionArn;
    }

    public final String tokenKeyName() {
        return this.tokenKeyName;
    }

    public final boolean hasTokenSigningPublicKeys() {
        return this.tokenSigningPublicKeys != null && !(this.tokenSigningPublicKeys instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tokenSigningPublicKeys() {
        return this.tokenSigningPublicKeys;
    }

    public final AuthorizerStatus status() {
        return AuthorizerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final Boolean signingDisabled() {
        return this.signingDisabled;
    }

    public final Boolean enableCachingForHttp() {
        return this.enableCachingForHttp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerFunctionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenSigningPublicKeys() ? this.tokenSigningPublicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableCachingForHttp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizerDescription)) {
            return false;
        }
        AuthorizerDescription other = (AuthorizerDescription)obj;
        return Objects.equals(this.authorizerName(), other.authorizerName()) && Objects.equals(this.authorizerArn(), other.authorizerArn()) && Objects.equals(this.authorizerFunctionArn(), other.authorizerFunctionArn()) && Objects.equals(this.tokenKeyName(), other.tokenKeyName()) && this.hasTokenSigningPublicKeys() == other.hasTokenSigningPublicKeys() && Objects.equals(this.tokenSigningPublicKeys(), other.tokenSigningPublicKeys()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.signingDisabled(), other.signingDisabled()) && Objects.equals(this.enableCachingForHttp(), other.enableCachingForHttp());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizerDescription").add("AuthorizerName", (Object)this.authorizerName()).add("AuthorizerArn", (Object)this.authorizerArn()).add("AuthorizerFunctionArn", (Object)this.authorizerFunctionArn()).add("TokenKeyName", (Object)this.tokenKeyName()).add("TokenSigningPublicKeys", this.hasTokenSigningPublicKeys() ? this.tokenSigningPublicKeys() : null).add("Status", (Object)this.statusAsString()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("SigningDisabled", (Object)this.signingDisabled()).add("EnableCachingForHttp", (Object)this.enableCachingForHttp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizerName": {
                return Optional.ofNullable(clazz.cast(this.authorizerName()));
            }
            case "authorizerArn": {
                return Optional.ofNullable(clazz.cast(this.authorizerArn()));
            }
            case "authorizerFunctionArn": {
                return Optional.ofNullable(clazz.cast(this.authorizerFunctionArn()));
            }
            case "tokenKeyName": {
                return Optional.ofNullable(clazz.cast(this.tokenKeyName()));
            }
            case "tokenSigningPublicKeys": {
                return Optional.ofNullable(clazz.cast(this.tokenSigningPublicKeys()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "signingDisabled": {
                return Optional.ofNullable(clazz.cast(this.signingDisabled()));
            }
            case "enableCachingForHttp": {
                return Optional.ofNullable(clazz.cast(this.enableCachingForHttp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizerDescription, T> g) {
        return obj -> g.apply((AuthorizerDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authorizerName;
        private String authorizerArn;
        private String authorizerFunctionArn;
        private String tokenKeyName;
        private Map<String, String> tokenSigningPublicKeys = DefaultSdkAutoConstructMap.getInstance();
        private String status;
        private Instant creationDate;
        private Instant lastModifiedDate;
        private Boolean signingDisabled;
        private Boolean enableCachingForHttp;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizerDescription model) {
            this.authorizerName(model.authorizerName);
            this.authorizerArn(model.authorizerArn);
            this.authorizerFunctionArn(model.authorizerFunctionArn);
            this.tokenKeyName(model.tokenKeyName);
            this.tokenSigningPublicKeys(model.tokenSigningPublicKeys);
            this.status(model.status);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
            this.signingDisabled(model.signingDisabled);
            this.enableCachingForHttp(model.enableCachingForHttp);
        }

        public final String getAuthorizerName() {
            return this.authorizerName;
        }

        public final void setAuthorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
        }

        @Override
        public final Builder authorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        public final String getAuthorizerArn() {
            return this.authorizerArn;
        }

        public final void setAuthorizerArn(String authorizerArn) {
            this.authorizerArn = authorizerArn;
        }

        @Override
        public final Builder authorizerArn(String authorizerArn) {
            this.authorizerArn = authorizerArn;
            return this;
        }

        public final String getAuthorizerFunctionArn() {
            return this.authorizerFunctionArn;
        }

        public final void setAuthorizerFunctionArn(String authorizerFunctionArn) {
            this.authorizerFunctionArn = authorizerFunctionArn;
        }

        @Override
        public final Builder authorizerFunctionArn(String authorizerFunctionArn) {
            this.authorizerFunctionArn = authorizerFunctionArn;
            return this;
        }

        public final String getTokenKeyName() {
            return this.tokenKeyName;
        }

        public final void setTokenKeyName(String tokenKeyName) {
            this.tokenKeyName = tokenKeyName;
        }

        @Override
        public final Builder tokenKeyName(String tokenKeyName) {
            this.tokenKeyName = tokenKeyName;
            return this;
        }

        public final Map<String, String> getTokenSigningPublicKeys() {
            if (this.tokenSigningPublicKeys instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tokenSigningPublicKeys;
        }

        public final void setTokenSigningPublicKeys(Map<String, String> tokenSigningPublicKeys) {
            this.tokenSigningPublicKeys = PublicKeyMapCopier.copy(tokenSigningPublicKeys);
        }

        @Override
        public final Builder tokenSigningPublicKeys(Map<String, String> tokenSigningPublicKeys) {
            this.tokenSigningPublicKeys = PublicKeyMapCopier.copy(tokenSigningPublicKeys);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AuthorizerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Boolean getSigningDisabled() {
            return this.signingDisabled;
        }

        public final void setSigningDisabled(Boolean signingDisabled) {
            this.signingDisabled = signingDisabled;
        }

        @Override
        public final Builder signingDisabled(Boolean signingDisabled) {
            this.signingDisabled = signingDisabled;
            return this;
        }

        public final Boolean getEnableCachingForHttp() {
            return this.enableCachingForHttp;
        }

        public final void setEnableCachingForHttp(Boolean enableCachingForHttp) {
            this.enableCachingForHttp = enableCachingForHttp;
        }

        @Override
        public final Builder enableCachingForHttp(Boolean enableCachingForHttp) {
            this.enableCachingForHttp = enableCachingForHttp;
            return this;
        }

        public AuthorizerDescription build() {
            return new AuthorizerDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthorizerDescription> {
        public Builder authorizerName(String var1);

        public Builder authorizerArn(String var1);

        public Builder authorizerFunctionArn(String var1);

        public Builder tokenKeyName(String var1);

        public Builder tokenSigningPublicKeys(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(AuthorizerStatus var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder signingDisabled(Boolean var1);

        public Builder enableCachingForHttp(Boolean var1);
    }
}

