/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListRelatedResourcesForAuditFindingRequest;
import software.amazon.awssdk.services.iot.model.ListRelatedResourcesForAuditFindingResponse;
import software.amazon.awssdk.services.iot.model.RelatedResource;

public class ListRelatedResourcesForAuditFindingPublisher
implements SdkPublisher<ListRelatedResourcesForAuditFindingResponse> {
    private final IotAsyncClient client;
    private final ListRelatedResourcesForAuditFindingRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRelatedResourcesForAuditFindingPublisher(IotAsyncClient client, ListRelatedResourcesForAuditFindingRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRelatedResourcesForAuditFindingPublisher(IotAsyncClient client, ListRelatedResourcesForAuditFindingRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRelatedResourcesForAuditFindingResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRelatedResourcesForAuditFindingResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RelatedResource> relatedResources() {
        Function<ListRelatedResourcesForAuditFindingResponse, Iterator> getIterator = response -> {
            if (response != null && response.relatedResources() != null) {
                return response.relatedResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRelatedResourcesForAuditFindingResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRelatedResourcesForAuditFindingResponseFetcher
    implements AsyncPageFetcher<ListRelatedResourcesForAuditFindingResponse> {
        private ListRelatedResourcesForAuditFindingResponseFetcher() {
        }

        public boolean hasNextPage(ListRelatedResourcesForAuditFindingResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRelatedResourcesForAuditFindingResponse> nextPage(ListRelatedResourcesForAuditFindingResponse previousPage) {
            if (previousPage == null) {
                return ListRelatedResourcesForAuditFindingPublisher.this.client.listRelatedResourcesForAuditFinding(ListRelatedResourcesForAuditFindingPublisher.this.firstRequest);
            }
            return ListRelatedResourcesForAuditFindingPublisher.this.client.listRelatedResourcesForAuditFinding((ListRelatedResourcesForAuditFindingRequest)((Object)ListRelatedResourcesForAuditFindingPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

