/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.AuthorizerSummary;
import software.amazon.awssdk.services.iot.model.ListAuthorizersRequest;
import software.amazon.awssdk.services.iot.model.ListAuthorizersResponse;

public class ListAuthorizersIterable
implements SdkIterable<ListAuthorizersResponse> {
    private final IotClient client;
    private final ListAuthorizersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAuthorizersIterable(IotClient client, ListAuthorizersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAuthorizersResponseFetcher();
    }

    public Iterator<ListAuthorizersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AuthorizerSummary> authorizers() {
        Function<ListAuthorizersResponse, Iterator> getIterator = response -> {
            if (response != null && response.authorizers() != null) {
                return response.authorizers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAuthorizersResponseFetcher
    implements SyncPageFetcher<ListAuthorizersResponse> {
        private ListAuthorizersResponseFetcher() {
        }

        public boolean hasNextPage(ListAuthorizersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListAuthorizersResponse nextPage(ListAuthorizersResponse previousPage) {
            if (previousPage == null) {
                return ListAuthorizersIterable.this.client.listAuthorizers(ListAuthorizersIterable.this.firstRequest);
            }
            return ListAuthorizersIterable.this.client.listAuthorizers((ListAuthorizersRequest)((Object)ListAuthorizersIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

