/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest;
import software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesResponse;
import software.amazon.awssdk.services.iot.model.ManagedJobTemplateSummary;

public class ListManagedJobTemplatesIterable
implements SdkIterable<ListManagedJobTemplatesResponse> {
    private final IotClient client;
    private final ListManagedJobTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedJobTemplatesIterable(IotClient client, ListManagedJobTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListManagedJobTemplatesResponseFetcher();
    }

    public Iterator<ListManagedJobTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ManagedJobTemplateSummary> managedJobTemplates() {
        Function<ListManagedJobTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedJobTemplates() != null) {
                return response.managedJobTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedJobTemplatesResponseFetcher
    implements SyncPageFetcher<ListManagedJobTemplatesResponse> {
        private ListManagedJobTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedJobTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedJobTemplatesResponse nextPage(ListManagedJobTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListManagedJobTemplatesIterable.this.client.listManagedJobTemplates(ListManagedJobTemplatesIterable.this.firstRequest);
            }
            return ListManagedJobTemplatesIterable.this.client.listManagedJobTemplates((ListManagedJobTemplatesRequest)((Object)ListManagedJobTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

