/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.CertificateProviderAccountDefaultForOperationsCopier;
import software.amazon.awssdk.services.iot.model.CertificateProviderOperation;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCertificateProviderResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeCertificateProviderResponse> {
    private static final SdkField<String> CERTIFICATE_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateProviderName").getter(DescribeCertificateProviderResponse.getter(DescribeCertificateProviderResponse::certificateProviderName)).setter(DescribeCertificateProviderResponse.setter(Builder::certificateProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateProviderName").build()}).build();
    private static final SdkField<String> CERTIFICATE_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateProviderArn").getter(DescribeCertificateProviderResponse.getter(DescribeCertificateProviderResponse::certificateProviderArn)).setter(DescribeCertificateProviderResponse.setter(Builder::certificateProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateProviderArn").build()}).build();
    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lambdaFunctionArn").getter(DescribeCertificateProviderResponse.getter(DescribeCertificateProviderResponse::lambdaFunctionArn)).setter(DescribeCertificateProviderResponse.setter(Builder::lambdaFunctionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionArn").build()}).build();
    private static final SdkField<List<String>> ACCOUNT_DEFAULT_FOR_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountDefaultForOperations").getter(DescribeCertificateProviderResponse.getter(DescribeCertificateProviderResponse::accountDefaultForOperationsAsStrings)).setter(DescribeCertificateProviderResponse.setter(Builder::accountDefaultForOperationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountDefaultForOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(DescribeCertificateProviderResponse.getter(DescribeCertificateProviderResponse::creationDate)).setter(DescribeCertificateProviderResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(DescribeCertificateProviderResponse.getter(DescribeCertificateProviderResponse::lastModifiedDate)).setter(DescribeCertificateProviderResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_PROVIDER_NAME_FIELD, CERTIFICATE_PROVIDER_ARN_FIELD, LAMBDA_FUNCTION_ARN_FIELD, ACCOUNT_DEFAULT_FOR_OPERATIONS_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private final String certificateProviderName;
    private final String certificateProviderArn;
    private final String lambdaFunctionArn;
    private final List<String> accountDefaultForOperations;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private DescribeCertificateProviderResponse(BuilderImpl builder) {
        super(builder);
        this.certificateProviderName = builder.certificateProviderName;
        this.certificateProviderArn = builder.certificateProviderArn;
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
        this.accountDefaultForOperations = builder.accountDefaultForOperations;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final String certificateProviderName() {
        return this.certificateProviderName;
    }

    public final String certificateProviderArn() {
        return this.certificateProviderArn;
    }

    public final String lambdaFunctionArn() {
        return this.lambdaFunctionArn;
    }

    public final List<CertificateProviderOperation> accountDefaultForOperations() {
        return CertificateProviderAccountDefaultForOperationsCopier.copyStringToEnum(this.accountDefaultForOperations);
    }

    public final boolean hasAccountDefaultForOperations() {
        return this.accountDefaultForOperations != null && !(this.accountDefaultForOperations instanceof SdkAutoConstructList);
    }

    public final List<String> accountDefaultForOperationsAsStrings() {
        return this.accountDefaultForOperations;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountDefaultForOperations() ? this.accountDefaultForOperationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCertificateProviderResponse)) {
            return false;
        }
        DescribeCertificateProviderResponse other = (DescribeCertificateProviderResponse)((Object)obj);
        return Objects.equals(this.certificateProviderName(), other.certificateProviderName()) && Objects.equals(this.certificateProviderArn(), other.certificateProviderArn()) && Objects.equals(this.lambdaFunctionArn(), other.lambdaFunctionArn()) && this.hasAccountDefaultForOperations() == other.hasAccountDefaultForOperations() && Objects.equals(this.accountDefaultForOperationsAsStrings(), other.accountDefaultForOperationsAsStrings()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCertificateProviderResponse").add("CertificateProviderName", (Object)this.certificateProviderName()).add("CertificateProviderArn", (Object)this.certificateProviderArn()).add("LambdaFunctionArn", (Object)this.lambdaFunctionArn()).add("AccountDefaultForOperations", this.hasAccountDefaultForOperations() ? this.accountDefaultForOperationsAsStrings() : null).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateProviderName": {
                return Optional.ofNullable(clazz.cast(this.certificateProviderName()));
            }
            case "certificateProviderArn": {
                return Optional.ofNullable(clazz.cast(this.certificateProviderArn()));
            }
            case "lambdaFunctionArn": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionArn()));
            }
            case "accountDefaultForOperations": {
                return Optional.ofNullable(clazz.cast(this.accountDefaultForOperationsAsStrings()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCertificateProviderResponse, T> g) {
        return obj -> g.apply((DescribeCertificateProviderResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String certificateProviderName;
        private String certificateProviderArn;
        private String lambdaFunctionArn;
        private List<String> accountDefaultForOperations = DefaultSdkAutoConstructList.getInstance();
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCertificateProviderResponse model) {
            super(model);
            this.certificateProviderName(model.certificateProviderName);
            this.certificateProviderArn(model.certificateProviderArn);
            this.lambdaFunctionArn(model.lambdaFunctionArn);
            this.accountDefaultForOperationsWithStrings(model.accountDefaultForOperations);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getCertificateProviderName() {
            return this.certificateProviderName;
        }

        public final void setCertificateProviderName(String certificateProviderName) {
            this.certificateProviderName = certificateProviderName;
        }

        @Override
        public final Builder certificateProviderName(String certificateProviderName) {
            this.certificateProviderName = certificateProviderName;
            return this;
        }

        public final String getCertificateProviderArn() {
            return this.certificateProviderArn;
        }

        public final void setCertificateProviderArn(String certificateProviderArn) {
            this.certificateProviderArn = certificateProviderArn;
        }

        @Override
        public final Builder certificateProviderArn(String certificateProviderArn) {
            this.certificateProviderArn = certificateProviderArn;
            return this;
        }

        public final String getLambdaFunctionArn() {
            return this.lambdaFunctionArn;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        public final Collection<String> getAccountDefaultForOperations() {
            if (this.accountDefaultForOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountDefaultForOperations;
        }

        public final void setAccountDefaultForOperations(Collection<String> accountDefaultForOperations) {
            this.accountDefaultForOperations = CertificateProviderAccountDefaultForOperationsCopier.copy(accountDefaultForOperations);
        }

        @Override
        public final Builder accountDefaultForOperationsWithStrings(Collection<String> accountDefaultForOperations) {
            this.accountDefaultForOperations = CertificateProviderAccountDefaultForOperationsCopier.copy(accountDefaultForOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDefaultForOperationsWithStrings(String ... accountDefaultForOperations) {
            this.accountDefaultForOperationsWithStrings(Arrays.asList(accountDefaultForOperations));
            return this;
        }

        @Override
        public final Builder accountDefaultForOperations(Collection<CertificateProviderOperation> accountDefaultForOperations) {
            this.accountDefaultForOperations = CertificateProviderAccountDefaultForOperationsCopier.copyEnumToString(accountDefaultForOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDefaultForOperations(CertificateProviderOperation ... accountDefaultForOperations) {
            this.accountDefaultForOperations(Arrays.asList(accountDefaultForOperations));
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public DescribeCertificateProviderResponse build() {
            return new DescribeCertificateProviderResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCertificateProviderResponse> {
        public Builder certificateProviderName(String var1);

        public Builder certificateProviderArn(String var1);

        public Builder lambdaFunctionArn(String var1);

        public Builder accountDefaultForOperationsWithStrings(Collection<String> var1);

        public Builder accountDefaultForOperationsWithStrings(String ... var1);

        public Builder accountDefaultForOperations(Collection<CertificateProviderOperation> var1);

        public Builder accountDefaultForOperations(CertificateProviderOperation ... var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

