/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListPackagesRequest;
import software.amazon.awssdk.services.iot.model.ListPackagesResponse;
import software.amazon.awssdk.services.iot.model.PackageSummary;

public class ListPackagesIterable
implements SdkIterable<ListPackagesResponse> {
    private final IotClient client;
    private final ListPackagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPackagesIterable(IotClient client, ListPackagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPackagesResponseFetcher();
    }

    public Iterator<ListPackagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PackageSummary> packageSummaries() {
        Function<ListPackagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.packageSummaries() != null) {
                return response.packageSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPackagesResponseFetcher
    implements SyncPageFetcher<ListPackagesResponse> {
        private ListPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPackagesResponse nextPage(ListPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListPackagesIterable.this.client.listPackages(ListPackagesIterable.this.firstRequest);
            }
            return ListPackagesIterable.this.client.listPackages((ListPackagesRequest)((Object)ListPackagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

