/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.JobExecutionSummaryForJob;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobResponse;

public class ListJobExecutionsForJobPublisher
implements SdkPublisher<ListJobExecutionsForJobResponse> {
    private final IotAsyncClient client;
    private final ListJobExecutionsForJobRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListJobExecutionsForJobPublisher(IotAsyncClient client, ListJobExecutionsForJobRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListJobExecutionsForJobPublisher(IotAsyncClient client, ListJobExecutionsForJobRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListJobExecutionsForJobResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListJobExecutionsForJobResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobExecutionSummaryForJob> executionSummaries() {
        Function<ListJobExecutionsForJobResponse, Iterator> getIterator = response -> {
            if (response != null && response.executionSummaries() != null) {
                return response.executionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListJobExecutionsForJobResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListJobExecutionsForJobResponseFetcher
    implements AsyncPageFetcher<ListJobExecutionsForJobResponse> {
        private ListJobExecutionsForJobResponseFetcher() {
        }

        public boolean hasNextPage(ListJobExecutionsForJobResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListJobExecutionsForJobResponse> nextPage(ListJobExecutionsForJobResponse previousPage) {
            if (previousPage == null) {
                return ListJobExecutionsForJobPublisher.this.client.listJobExecutionsForJob(ListJobExecutionsForJobPublisher.this.firstRequest);
            }
            return ListJobExecutionsForJobPublisher.this.client.listJobExecutionsForJob((ListJobExecutionsForJobRequest)((Object)ListJobExecutionsForJobPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

