/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListThingsInThingGroupRequest;
import software.amazon.awssdk.services.iot.model.ListThingsInThingGroupResponse;

public class ListThingsInThingGroupPublisher
implements SdkPublisher<ListThingsInThingGroupResponse> {
    private final IotAsyncClient client;
    private final ListThingsInThingGroupRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListThingsInThingGroupPublisher(IotAsyncClient client, ListThingsInThingGroupRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListThingsInThingGroupPublisher(IotAsyncClient client, ListThingsInThingGroupRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListThingsInThingGroupResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListThingsInThingGroupResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> things() {
        Function<ListThingsInThingGroupResponse, Iterator> getIterator = response -> {
            if (response != null && response.things() != null) {
                return response.things().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListThingsInThingGroupResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListThingsInThingGroupResponseFetcher
    implements AsyncPageFetcher<ListThingsInThingGroupResponse> {
        private ListThingsInThingGroupResponseFetcher() {
        }

        public boolean hasNextPage(ListThingsInThingGroupResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListThingsInThingGroupResponse> nextPage(ListThingsInThingGroupResponse previousPage) {
            if (previousPage == null) {
                return ListThingsInThingGroupPublisher.this.client.listThingsInThingGroup(ListThingsInThingGroupPublisher.this.firstRequest);
            }
            return ListThingsInThingGroupPublisher.this.client.listThingsInThingGroup((ListThingsInThingGroupRequest)((Object)ListThingsInThingGroupPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

