/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.DomainConfigurationSummary;
import software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.ListDomainConfigurationsResponse;

public class ListDomainConfigurationsIterable
implements SdkIterable<ListDomainConfigurationsResponse> {
    private final IotClient client;
    private final ListDomainConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDomainConfigurationsIterable(IotClient client, ListDomainConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDomainConfigurationsResponseFetcher();
    }

    public Iterator<ListDomainConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DomainConfigurationSummary> domainConfigurations() {
        Function<ListDomainConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.domainConfigurations() != null) {
                return response.domainConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDomainConfigurationsResponseFetcher
    implements SyncPageFetcher<ListDomainConfigurationsResponse> {
        private ListDomainConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListDomainConfigurationsResponse nextPage(ListDomainConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainConfigurationsIterable.this.client.listDomainConfigurations(ListDomainConfigurationsIterable.this.firstRequest);
            }
            return ListDomainConfigurationsIterable.this.client.listDomainConfigurations((ListDomainConfigurationsRequest)((Object)ListDomainConfigurationsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

