/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.AuditFinding;
import software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditFindingsResponse;

public class ListAuditFindingsIterable
implements SdkIterable<ListAuditFindingsResponse> {
    private final IotClient client;
    private final ListAuditFindingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAuditFindingsIterable(IotClient client, ListAuditFindingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAuditFindingsResponseFetcher();
    }

    public Iterator<ListAuditFindingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AuditFinding> findings() {
        Function<ListAuditFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAuditFindingsResponseFetcher
    implements SyncPageFetcher<ListAuditFindingsResponse> {
        private ListAuditFindingsResponseFetcher() {
        }

        public boolean hasNextPage(ListAuditFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAuditFindingsResponse nextPage(ListAuditFindingsResponse previousPage) {
            if (previousPage == null) {
                return ListAuditFindingsIterable.this.client.listAuditFindings(ListAuditFindingsIterable.this.firstRequest);
            }
            return ListAuditFindingsIterable.this.client.listAuditFindings((ListAuditFindingsRequest)((Object)ListAuditFindingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

