/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of the CreateKeysAndCertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKeysAndCertificateResponse extends IotResponse implements
        ToCopyableBuilder<CreateKeysAndCertificateResponse.Builder, CreateKeysAndCertificateResponse> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateArn").getter(getter(CreateKeysAndCertificateResponse::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()).build();

    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateId").getter(getter(CreateKeysAndCertificateResponse::certificateId))
            .setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateId").build()).build();

    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificatePem").getter(getter(CreateKeysAndCertificateResponse::certificatePem))
            .setter(setter(Builder::certificatePem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePem").build()).build();

    private static final SdkField<KeyPair> KEY_PAIR_FIELD = SdkField.<KeyPair> builder(MarshallingType.SDK_POJO)
            .memberName("keyPair").getter(getter(CreateKeysAndCertificateResponse::keyPair)).setter(setter(Builder::keyPair))
            .constructor(KeyPair::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPair").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD,
            CERTIFICATE_ID_FIELD, CERTIFICATE_PEM_FIELD, KEY_PAIR_FIELD));

    private final String certificateArn;

    private final String certificateId;

    private final String certificatePem;

    private final KeyPair keyPair;

    private CreateKeysAndCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.certificatePem = builder.certificatePem;
        this.keyPair = builder.keyPair;
    }

    /**
     * <p>
     * The ARN of the certificate.
     * </p>
     * 
     * @return The ARN of the certificate.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The ID of the certificate. IoT issues a default subject name for the certificate (for example, IoT Certificate).
     * </p>
     * 
     * @return The ID of the certificate. IoT issues a default subject name for the certificate (for example, IoT
     *         Certificate).
     */
    public final String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The certificate data, in PEM format.
     * </p>
     * 
     * @return The certificate data, in PEM format.
     */
    public final String certificatePem() {
        return certificatePem;
    }

    /**
     * <p>
     * The generated key pair.
     * </p>
     * 
     * @return The generated key pair.
     */
    public final KeyPair keyPair() {
        return keyPair;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(keyPair());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeysAndCertificateResponse)) {
            return false;
        }
        CreateKeysAndCertificateResponse other = (CreateKeysAndCertificateResponse) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(certificatePem(), other.certificatePem()) && Objects.equals(keyPair(), other.keyPair());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateKeysAndCertificateResponse").add("CertificateArn", certificateArn())
                .add("CertificateId", certificateId()).add("CertificatePem", certificatePem()).add("KeyPair", keyPair()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "certificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "certificatePem":
            return Optional.ofNullable(clazz.cast(certificatePem()));
        case "keyPair":
            return Optional.ofNullable(clazz.cast(keyPair()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKeysAndCertificateResponse, T> g) {
        return obj -> g.apply((CreateKeysAndCertificateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateKeysAndCertificateResponse> {
        /**
         * <p>
         * The ARN of the certificate.
         * </p>
         * 
         * @param certificateArn
         *        The ARN of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The ID of the certificate. IoT issues a default subject name for the certificate (for example, IoT
         * Certificate).
         * </p>
         * 
         * @param certificateId
         *        The ID of the certificate. IoT issues a default subject name for the certificate (for example, IoT
         *        Certificate).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The certificate data, in PEM format.
         * </p>
         * 
         * @param certificatePem
         *        The certificate data, in PEM format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);

        /**
         * <p>
         * The generated key pair.
         * </p>
         * 
         * @param keyPair
         *        The generated key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPair(KeyPair keyPair);

        /**
         * <p>
         * The generated key pair.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyPair.Builder} avoiding the need to
         * create one manually via {@link KeyPair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyPair.Builder#build()} is called immediately and its result is
         * passed to {@link #keyPair(KeyPair)}.
         * 
         * @param keyPair
         *        a consumer that will call methods on {@link KeyPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPair(KeyPair)
         */
        default Builder keyPair(Consumer<KeyPair.Builder> keyPair) {
            return keyPair(KeyPair.builder().applyMutation(keyPair).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateId;

        private String certificatePem;

        private KeyPair keyPair;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeysAndCertificateResponse model) {
            super(model);
            certificateArn(model.certificateArn);
            certificateId(model.certificateId);
            certificatePem(model.certificatePem);
            keyPair(model.keyPair);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final KeyPair.Builder getKeyPair() {
            return keyPair != null ? keyPair.toBuilder() : null;
        }

        public final void setKeyPair(KeyPair.BuilderImpl keyPair) {
            this.keyPair = keyPair != null ? keyPair.build() : null;
        }

        @Override
        public final Builder keyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        @Override
        public CreateKeysAndCertificateResponse build() {
            return new CreateKeysAndCertificateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
