/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListRelatedResourcesForAuditFindingRequest;
import software.amazon.awssdk.services.iot.model.ListRelatedResourcesForAuditFindingResponse;
import software.amazon.awssdk.services.iot.model.RelatedResource;

public class ListRelatedResourcesForAuditFindingIterable
implements SdkIterable<ListRelatedResourcesForAuditFindingResponse> {
    private final IotClient client;
    private final ListRelatedResourcesForAuditFindingRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRelatedResourcesForAuditFindingIterable(IotClient client, ListRelatedResourcesForAuditFindingRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRelatedResourcesForAuditFindingResponseFetcher();
    }

    public Iterator<ListRelatedResourcesForAuditFindingResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RelatedResource> relatedResources() {
        Function<ListRelatedResourcesForAuditFindingResponse, Iterator> getIterator = response -> {
            if (response != null && response.relatedResources() != null) {
                return response.relatedResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRelatedResourcesForAuditFindingResponseFetcher
    implements SyncPageFetcher<ListRelatedResourcesForAuditFindingResponse> {
        private ListRelatedResourcesForAuditFindingResponseFetcher() {
        }

        public boolean hasNextPage(ListRelatedResourcesForAuditFindingResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRelatedResourcesForAuditFindingResponse nextPage(ListRelatedResourcesForAuditFindingResponse previousPage) {
            if (previousPage == null) {
                return ListRelatedResourcesForAuditFindingIterable.this.client.listRelatedResourcesForAuditFinding(ListRelatedResourcesForAuditFindingIterable.this.firstRequest);
            }
            return ListRelatedResourcesForAuditFindingIterable.this.client.listRelatedResourcesForAuditFinding((ListRelatedResourcesForAuditFindingRequest)((Object)ListRelatedResourcesForAuditFindingIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

