/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListStreamsRequest;
import software.amazon.awssdk.services.iot.model.ListStreamsResponse;
import software.amazon.awssdk.services.iot.model.StreamSummary;

public class ListStreamsPublisher
implements SdkPublisher<ListStreamsResponse> {
    private final IotAsyncClient client;
    private final ListStreamsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStreamsPublisher(IotAsyncClient client, ListStreamsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStreamsPublisher(IotAsyncClient client, ListStreamsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStreamsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStreamsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StreamSummary> streams() {
        Function<ListStreamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.streams() != null) {
                return response.streams().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStreamsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStreamsResponseFetcher
    implements AsyncPageFetcher<ListStreamsResponse> {
        private ListStreamsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStreamsResponse> nextPage(ListStreamsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamsPublisher.this.client.listStreams(ListStreamsPublisher.this.firstRequest);
            }
            return ListStreamsPublisher.this.client.listStreams((ListStreamsRequest)((Object)ListStreamsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

