/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListIndicesRequest;
import software.amazon.awssdk.services.iot.model.ListIndicesResponse;

public class ListIndicesIterable
implements SdkIterable<ListIndicesResponse> {
    private final IotClient client;
    private final ListIndicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIndicesIterable(IotClient client, ListIndicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListIndicesResponseFetcher();
    }

    public Iterator<ListIndicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> indexNames() {
        Function<ListIndicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.indexNames() != null) {
                return response.indexNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIndicesResponseFetcher
    implements SyncPageFetcher<ListIndicesResponse> {
        private ListIndicesResponseFetcher() {
        }

        public boolean hasNextPage(ListIndicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIndicesResponse nextPage(ListIndicesResponse previousPage) {
            if (previousPage == null) {
                return ListIndicesIterable.this.client.listIndices(ListIndicesIterable.this.firstRequest);
            }
            return ListIndicesIterable.this.client.listIndices((ListIndicesRequest)((Object)ListIndicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

