/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsRequest;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsResponse;

public class ListThingPrincipalsPublisher
implements SdkPublisher<ListThingPrincipalsResponse> {
    private final IotAsyncClient client;
    private final ListThingPrincipalsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListThingPrincipalsPublisher(IotAsyncClient client, ListThingPrincipalsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListThingPrincipalsPublisher(IotAsyncClient client, ListThingPrincipalsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListThingPrincipalsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListThingPrincipalsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> principals() {
        Function<ListThingPrincipalsResponse, Iterator> getIterator = response -> {
            if (response != null && response.principals() != null) {
                return response.principals().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListThingPrincipalsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListThingPrincipalsResponseFetcher
    implements AsyncPageFetcher<ListThingPrincipalsResponse> {
        private ListThingPrincipalsResponseFetcher() {
        }

        public boolean hasNextPage(ListThingPrincipalsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListThingPrincipalsResponse> nextPage(ListThingPrincipalsResponse previousPage) {
            if (previousPage == null) {
                return ListThingPrincipalsPublisher.this.client.listThingPrincipals(ListThingPrincipalsPublisher.this.firstRequest);
            }
            return ListThingPrincipalsPublisher.this.client.listThingPrincipals((ListThingPrincipalsRequest)((Object)ListThingPrincipalsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

