/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iot.DefaultIotAsyncClient;
import software.amazon.awssdk.services.iot.DefaultIotBaseClientBuilder;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.IotAsyncClientBuilder;
import software.amazon.awssdk.services.iot.IotServiceClientConfiguration;
import software.amazon.awssdk.services.iot.endpoints.IotEndpointProvider;

@SdkInternalApi
final class DefaultIotAsyncClientBuilder
extends DefaultIotBaseClientBuilder<IotAsyncClientBuilder, IotAsyncClient>
implements IotAsyncClientBuilder {
    DefaultIotAsyncClientBuilder() {
    }

    @Override
    public DefaultIotAsyncClientBuilder endpointProvider(IotEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IotAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIotAsyncClientBuilder.validateClientOptions(clientConfiguration);
        IotServiceClientConfiguration serviceClientConfiguration = IotServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultIotAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

