/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListIndicesRequest;
import software.amazon.awssdk.services.iot.model.ListIndicesResponse;

public class ListIndicesPublisher
implements SdkPublisher<ListIndicesResponse> {
    private final IotAsyncClient client;
    private final ListIndicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIndicesPublisher(IotAsyncClient client, ListIndicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIndicesPublisher(IotAsyncClient client, ListIndicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIndicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIndicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> indexNames() {
        Function<ListIndicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.indexNames() != null) {
                return response.indexNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIndicesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIndicesResponseFetcher
    implements AsyncPageFetcher<ListIndicesResponse> {
        private ListIndicesResponseFetcher() {
        }

        public boolean hasNextPage(ListIndicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIndicesResponse> nextPage(ListIndicesResponse previousPage) {
            if (previousPage == null) {
                return ListIndicesPublisher.this.client.listIndices(ListIndicesPublisher.this.firstRequest);
            }
            return ListIndicesPublisher.this.client.listIndices((ListIndicesRequest)((Object)ListIndicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

