/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iot.DefaultIotAsyncClient;
import software.amazon.awssdk.services.iot.DefaultIotBaseClientBuilder;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.IotAsyncClientBuilder;
import software.amazon.awssdk.services.iot.IotServiceClientConfiguration;
import software.amazon.awssdk.services.iot.endpoints.IotEndpointProvider;

@SdkInternalApi
final class DefaultIotAsyncClientBuilder
extends DefaultIotBaseClientBuilder<IotAsyncClientBuilder, IotAsyncClient>
implements IotAsyncClientBuilder {
    DefaultIotAsyncClientBuilder() {
    }

    @Override
    public DefaultIotAsyncClientBuilder endpointProvider(IotEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IotAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIotAsyncClientBuilder.validateClientOptions(clientConfiguration);
        IotServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIotAsyncClient client = new DefaultIotAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IotServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IotServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

