/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.Behavior;
import software.amazon.awssdk.services.iot.model.MetricValue;
import software.amazon.awssdk.services.iot.model.ViolationEventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ViolationEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ViolationEvent> {
    private static final SdkField<String> VIOLATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ViolationEvent.getter(ViolationEvent::violationId)).setter(ViolationEvent.setter(Builder::violationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationId").build()}).build();
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ViolationEvent.getter(ViolationEvent::thingName)).setter(ViolationEvent.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()}).build();
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ViolationEvent.getter(ViolationEvent::securityProfileName)).setter(ViolationEvent.setter(Builder::securityProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileName").build()}).build();
    private static final SdkField<Behavior> BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ViolationEvent.getter(ViolationEvent::behavior)).setter(ViolationEvent.setter(Builder::behavior)).constructor(Behavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behavior").build()}).build();
    private static final SdkField<MetricValue> METRIC_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ViolationEvent.getter(ViolationEvent::metricValue)).setter(ViolationEvent.setter(Builder::metricValue)).constructor(MetricValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricValue").build()}).build();
    private static final SdkField<String> VIOLATION_EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ViolationEvent.getter(ViolationEvent::violationEventTypeAsString)).setter(ViolationEvent.setter(Builder::violationEventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEventType").build()}).build();
    private static final SdkField<Instant> VIOLATION_EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ViolationEvent.getter(ViolationEvent::violationEventTime)).setter(ViolationEvent.setter(Builder::violationEventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEventTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_ID_FIELD, THING_NAME_FIELD, SECURITY_PROFILE_NAME_FIELD, BEHAVIOR_FIELD, METRIC_VALUE_FIELD, VIOLATION_EVENT_TYPE_FIELD, VIOLATION_EVENT_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String violationId;
    private final String thingName;
    private final String securityProfileName;
    private final Behavior behavior;
    private final MetricValue metricValue;
    private final String violationEventType;
    private final Instant violationEventTime;

    private ViolationEvent(BuilderImpl builder) {
        this.violationId = builder.violationId;
        this.thingName = builder.thingName;
        this.securityProfileName = builder.securityProfileName;
        this.behavior = builder.behavior;
        this.metricValue = builder.metricValue;
        this.violationEventType = builder.violationEventType;
        this.violationEventTime = builder.violationEventTime;
    }

    public String violationId() {
        return this.violationId;
    }

    public String thingName() {
        return this.thingName;
    }

    public String securityProfileName() {
        return this.securityProfileName;
    }

    public Behavior behavior() {
        return this.behavior;
    }

    public MetricValue metricValue() {
        return this.metricValue;
    }

    public ViolationEventType violationEventType() {
        return ViolationEventType.fromValue(this.violationEventType);
    }

    public String violationEventTypeAsString() {
        return this.violationEventType;
    }

    public Instant violationEventTime() {
        return this.violationEventTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.violationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.behavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.violationEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.violationEventTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViolationEvent)) {
            return false;
        }
        ViolationEvent other = (ViolationEvent)obj;
        return Objects.equals(this.violationId(), other.violationId()) && Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.behavior(), other.behavior()) && Objects.equals(this.metricValue(), other.metricValue()) && Objects.equals(this.violationEventTypeAsString(), other.violationEventTypeAsString()) && Objects.equals(this.violationEventTime(), other.violationEventTime());
    }

    public String toString() {
        return ToString.builder((String)"ViolationEvent").add("ViolationId", (Object)this.violationId()).add("ThingName", (Object)this.thingName()).add("SecurityProfileName", (Object)this.securityProfileName()).add("Behavior", (Object)this.behavior()).add("MetricValue", (Object)this.metricValue()).add("ViolationEventType", (Object)this.violationEventTypeAsString()).add("ViolationEventTime", (Object)this.violationEventTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "violationId": {
                return Optional.ofNullable(clazz.cast(this.violationId()));
            }
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "securityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "behavior": {
                return Optional.ofNullable(clazz.cast(this.behavior()));
            }
            case "metricValue": {
                return Optional.ofNullable(clazz.cast(this.metricValue()));
            }
            case "violationEventType": {
                return Optional.ofNullable(clazz.cast(this.violationEventTypeAsString()));
            }
            case "violationEventTime": {
                return Optional.ofNullable(clazz.cast(this.violationEventTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ViolationEvent, T> g) {
        return obj -> g.apply((ViolationEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String violationId;
        private String thingName;
        private String securityProfileName;
        private Behavior behavior;
        private MetricValue metricValue;
        private String violationEventType;
        private Instant violationEventTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ViolationEvent model) {
            this.violationId(model.violationId);
            this.thingName(model.thingName);
            this.securityProfileName(model.securityProfileName);
            this.behavior(model.behavior);
            this.metricValue(model.metricValue);
            this.violationEventType(model.violationEventType);
            this.violationEventTime(model.violationEventTime);
        }

        public final String getViolationId() {
            return this.violationId;
        }

        @Override
        public final Builder violationId(String violationId) {
            this.violationId = violationId;
            return this;
        }

        public final void setViolationId(String violationId) {
            this.violationId = violationId;
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final Behavior.Builder getBehavior() {
            return this.behavior != null ? this.behavior.toBuilder() : null;
        }

        @Override
        public final Builder behavior(Behavior behavior) {
            this.behavior = behavior;
            return this;
        }

        public final void setBehavior(Behavior.BuilderImpl behavior) {
            this.behavior = behavior != null ? behavior.build() : null;
        }

        public final MetricValue.Builder getMetricValue() {
            return this.metricValue != null ? this.metricValue.toBuilder() : null;
        }

        @Override
        public final Builder metricValue(MetricValue metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final void setMetricValue(MetricValue.BuilderImpl metricValue) {
            this.metricValue = metricValue != null ? metricValue.build() : null;
        }

        public final String getViolationEventType() {
            return this.violationEventType;
        }

        @Override
        public final Builder violationEventType(String violationEventType) {
            this.violationEventType = violationEventType;
            return this;
        }

        @Override
        public final Builder violationEventType(ViolationEventType violationEventType) {
            this.violationEventType(violationEventType.toString());
            return this;
        }

        public final void setViolationEventType(String violationEventType) {
            this.violationEventType = violationEventType;
        }

        public final Instant getViolationEventTime() {
            return this.violationEventTime;
        }

        @Override
        public final Builder violationEventTime(Instant violationEventTime) {
            this.violationEventTime = violationEventTime;
            return this;
        }

        public final void setViolationEventTime(Instant violationEventTime) {
            this.violationEventTime = violationEventTime;
        }

        public ViolationEvent build() {
            return new ViolationEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ViolationEvent> {
        public Builder violationId(String var1);

        public Builder thingName(String var1);

        public Builder securityProfileName(String var1);

        public Builder behavior(Behavior var1);

        default public Builder behavior(Consumer<Behavior.Builder> behavior) {
            return this.behavior((Behavior)((Behavior.Builder)Behavior.builder().applyMutation(behavior)).build());
        }

        public Builder metricValue(MetricValue var1);

        default public Builder metricValue(Consumer<MetricValue.Builder> metricValue) {
            return this.metricValue((MetricValue)((MetricValue.Builder)MetricValue.builder().applyMutation(metricValue)).build());
        }

        public Builder violationEventType(String var1);

        public Builder violationEventType(ViolationEventType var1);

        public Builder violationEventTime(Instant var1);
    }
}

