/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.ComparisonOperator;
import software.amazon.awssdk.services.iot.model.MetricValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BehaviorCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BehaviorCriteria> {
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BehaviorCriteria.getter(BehaviorCriteria::comparisonOperatorAsString)).setter(BehaviorCriteria.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparisonOperator").build()}).build();
    private static final SdkField<MetricValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BehaviorCriteria.getter(BehaviorCriteria::value)).setter(BehaviorCriteria.setter(Builder::value)).constructor(MetricValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BehaviorCriteria.getter(BehaviorCriteria::durationSeconds)).setter(BehaviorCriteria.setter(Builder::durationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARISON_OPERATOR_FIELD, VALUE_FIELD, DURATION_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comparisonOperator;
    private final MetricValue value;
    private final Integer durationSeconds;

    private BehaviorCriteria(BuilderImpl builder) {
        this.comparisonOperator = builder.comparisonOperator;
        this.value = builder.value;
        this.durationSeconds = builder.durationSeconds;
    }

    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public MetricValue value() {
        return this.value;
    }

    public Integer durationSeconds() {
        return this.durationSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BehaviorCriteria)) {
            return false;
        }
        BehaviorCriteria other = (BehaviorCriteria)obj;
        return Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.durationSeconds(), other.durationSeconds());
    }

    public String toString() {
        return ToString.builder((String)"BehaviorCriteria").add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("Value", (Object)this.value()).add("DurationSeconds", (Object)this.durationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "comparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "durationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BehaviorCriteria, T> g) {
        return obj -> g.apply((BehaviorCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comparisonOperator;
        private MetricValue value;
        private Integer durationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(BehaviorCriteria model) {
            this.comparisonOperator(model.comparisonOperator);
            this.value(model.value);
            this.durationSeconds(model.durationSeconds);
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final MetricValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        @Override
        public final Builder value(MetricValue value) {
            this.value = value;
            return this;
        }

        public final void setValue(MetricValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        public BehaviorCriteria build() {
            return new BehaviorCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BehaviorCriteria> {
        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder value(MetricValue var1);

        default public Builder value(Consumer<MetricValue.Builder> value) {
            return this.value((MetricValue)((MetricValue.Builder)MetricValue.builder().applyMutation(value)).build());
        }

        public Builder durationSeconds(Integer var1);
    }
}

