/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsRequest;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsResponse;

public class ListThingRegistrationTaskReportsIterable
implements SdkIterable<ListThingRegistrationTaskReportsResponse> {
    private final IotClient client;
    private final ListThingRegistrationTaskReportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThingRegistrationTaskReportsIterable(IotClient client, ListThingRegistrationTaskReportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListThingRegistrationTaskReportsResponseFetcher();
    }

    public Iterator<ListThingRegistrationTaskReportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> resourceLinks() {
        Function<ListThingRegistrationTaskReportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceLinks() != null) {
                return response.resourceLinks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListThingRegistrationTaskReportsResponseFetcher
    implements SyncPageFetcher<ListThingRegistrationTaskReportsResponse> {
        private ListThingRegistrationTaskReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListThingRegistrationTaskReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListThingRegistrationTaskReportsResponse nextPage(ListThingRegistrationTaskReportsResponse previousPage) {
            if (previousPage == null) {
                return ListThingRegistrationTaskReportsIterable.this.client.listThingRegistrationTaskReports(ListThingRegistrationTaskReportsIterable.this.firstRequest);
            }
            return ListThingRegistrationTaskReportsIterable.this.client.listThingRegistrationTaskReports((ListThingRegistrationTaskReportsRequest)((Object)ListThingRegistrationTaskReportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

