/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.GroupNameAndArn;
import software.amazon.awssdk.services.iot.model.ListThingGroupsForThingRequest;
import software.amazon.awssdk.services.iot.model.ListThingGroupsForThingResponse;

public class ListThingGroupsForThingPublisher
implements SdkPublisher<ListThingGroupsForThingResponse> {
    private final IotAsyncClient client;
    private final ListThingGroupsForThingRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListThingGroupsForThingPublisher(IotAsyncClient client, ListThingGroupsForThingRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListThingGroupsForThingPublisher(IotAsyncClient client, ListThingGroupsForThingRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListThingGroupsForThingResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListThingGroupsForThingResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GroupNameAndArn> thingGroups() {
        Function<ListThingGroupsForThingResponse, Iterator> getIterator = response -> {
            if (response != null && response.thingGroups() != null) {
                return response.thingGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListThingGroupsForThingResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListThingGroupsForThingResponseFetcher
    implements AsyncPageFetcher<ListThingGroupsForThingResponse> {
        private ListThingGroupsForThingResponseFetcher() {
        }

        public boolean hasNextPage(ListThingGroupsForThingResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListThingGroupsForThingResponse> nextPage(ListThingGroupsForThingResponse previousPage) {
            if (previousPage == null) {
                return ListThingGroupsForThingPublisher.this.client.listThingGroupsForThing(ListThingGroupsForThingPublisher.this.firstRequest);
            }
            return ListThingGroupsForThingPublisher.this.client.listThingGroupsForThing((ListThingGroupsForThingRequest)((Object)ListThingGroupsForThingPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

