/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AuthorizerStatus;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.PublicKeyMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAuthorizerRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateAuthorizerRequest> {
    private static final SdkField<String> AUTHORIZER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizerName").getter(UpdateAuthorizerRequest.getter(UpdateAuthorizerRequest::authorizerName)).setter(UpdateAuthorizerRequest.setter(Builder::authorizerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("authorizerName").build()}).build();
    private static final SdkField<String> AUTHORIZER_FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizerFunctionArn").getter(UpdateAuthorizerRequest.getter(UpdateAuthorizerRequest::authorizerFunctionArn)).setter(UpdateAuthorizerRequest.setter(Builder::authorizerFunctionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerFunctionArn").build()}).build();
    private static final SdkField<String> TOKEN_KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenKeyName").getter(UpdateAuthorizerRequest.getter(UpdateAuthorizerRequest::tokenKeyName)).setter(UpdateAuthorizerRequest.setter(Builder::tokenKeyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenKeyName").build()}).build();
    private static final SdkField<Map<String, String>> TOKEN_SIGNING_PUBLIC_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tokenSigningPublicKeys").getter(UpdateAuthorizerRequest.getter(UpdateAuthorizerRequest::tokenSigningPublicKeys)).setter(UpdateAuthorizerRequest.setter(Builder::tokenSigningPublicKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenSigningPublicKeys").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateAuthorizerRequest.getter(UpdateAuthorizerRequest::statusAsString)).setter(UpdateAuthorizerRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZER_NAME_FIELD, AUTHORIZER_FUNCTION_ARN_FIELD, TOKEN_KEY_NAME_FIELD, TOKEN_SIGNING_PUBLIC_KEYS_FIELD, STATUS_FIELD));
    private final String authorizerName;
    private final String authorizerFunctionArn;
    private final String tokenKeyName;
    private final Map<String, String> tokenSigningPublicKeys;
    private final String status;

    private UpdateAuthorizerRequest(BuilderImpl builder) {
        super(builder);
        this.authorizerName = builder.authorizerName;
        this.authorizerFunctionArn = builder.authorizerFunctionArn;
        this.tokenKeyName = builder.tokenKeyName;
        this.tokenSigningPublicKeys = builder.tokenSigningPublicKeys;
        this.status = builder.status;
    }

    public final String authorizerName() {
        return this.authorizerName;
    }

    public final String authorizerFunctionArn() {
        return this.authorizerFunctionArn;
    }

    public final String tokenKeyName() {
        return this.tokenKeyName;
    }

    public final boolean hasTokenSigningPublicKeys() {
        return this.tokenSigningPublicKeys != null && !(this.tokenSigningPublicKeys instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tokenSigningPublicKeys() {
        return this.tokenSigningPublicKeys;
    }

    public final AuthorizerStatus status() {
        return AuthorizerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerFunctionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenSigningPublicKeys() ? this.tokenSigningPublicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAuthorizerRequest)) {
            return false;
        }
        UpdateAuthorizerRequest other = (UpdateAuthorizerRequest)((Object)obj);
        return Objects.equals(this.authorizerName(), other.authorizerName()) && Objects.equals(this.authorizerFunctionArn(), other.authorizerFunctionArn()) && Objects.equals(this.tokenKeyName(), other.tokenKeyName()) && this.hasTokenSigningPublicKeys() == other.hasTokenSigningPublicKeys() && Objects.equals(this.tokenSigningPublicKeys(), other.tokenSigningPublicKeys()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAuthorizerRequest").add("AuthorizerName", (Object)this.authorizerName()).add("AuthorizerFunctionArn", (Object)this.authorizerFunctionArn()).add("TokenKeyName", (Object)this.tokenKeyName()).add("TokenSigningPublicKeys", this.hasTokenSigningPublicKeys() ? this.tokenSigningPublicKeys() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizerName": {
                return Optional.ofNullable(clazz.cast(this.authorizerName()));
            }
            case "authorizerFunctionArn": {
                return Optional.ofNullable(clazz.cast(this.authorizerFunctionArn()));
            }
            case "tokenKeyName": {
                return Optional.ofNullable(clazz.cast(this.tokenKeyName()));
            }
            case "tokenSigningPublicKeys": {
                return Optional.ofNullable(clazz.cast(this.tokenSigningPublicKeys()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAuthorizerRequest, T> g) {
        return obj -> g.apply((UpdateAuthorizerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String authorizerName;
        private String authorizerFunctionArn;
        private String tokenKeyName;
        private Map<String, String> tokenSigningPublicKeys = DefaultSdkAutoConstructMap.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAuthorizerRequest model) {
            super(model);
            this.authorizerName(model.authorizerName);
            this.authorizerFunctionArn(model.authorizerFunctionArn);
            this.tokenKeyName(model.tokenKeyName);
            this.tokenSigningPublicKeys(model.tokenSigningPublicKeys);
            this.status(model.status);
        }

        public final String getAuthorizerName() {
            return this.authorizerName;
        }

        public final void setAuthorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
        }

        @Override
        @Transient
        public final Builder authorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        public final String getAuthorizerFunctionArn() {
            return this.authorizerFunctionArn;
        }

        public final void setAuthorizerFunctionArn(String authorizerFunctionArn) {
            this.authorizerFunctionArn = authorizerFunctionArn;
        }

        @Override
        @Transient
        public final Builder authorizerFunctionArn(String authorizerFunctionArn) {
            this.authorizerFunctionArn = authorizerFunctionArn;
            return this;
        }

        public final String getTokenKeyName() {
            return this.tokenKeyName;
        }

        public final void setTokenKeyName(String tokenKeyName) {
            this.tokenKeyName = tokenKeyName;
        }

        @Override
        @Transient
        public final Builder tokenKeyName(String tokenKeyName) {
            this.tokenKeyName = tokenKeyName;
            return this;
        }

        public final Map<String, String> getTokenSigningPublicKeys() {
            if (this.tokenSigningPublicKeys instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tokenSigningPublicKeys;
        }

        public final void setTokenSigningPublicKeys(Map<String, String> tokenSigningPublicKeys) {
            this.tokenSigningPublicKeys = PublicKeyMapCopier.copy(tokenSigningPublicKeys);
        }

        @Override
        @Transient
        public final Builder tokenSigningPublicKeys(Map<String, String> tokenSigningPublicKeys) {
            this.tokenSigningPublicKeys = PublicKeyMapCopier.copy(tokenSigningPublicKeys);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(AuthorizerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAuthorizerRequest build() {
            return new UpdateAuthorizerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAuthorizerRequest> {
        public Builder authorizerName(String var1);

        public Builder authorizerFunctionArn(String var1);

        public Builder tokenKeyName(String var1);

        public Builder tokenSigningPublicKeys(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(AuthorizerStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

