/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.DeviceDefenderIndexingMode;
import software.amazon.awssdk.services.iot.model.Field;
import software.amazon.awssdk.services.iot.model.FieldsCopier;
import software.amazon.awssdk.services.iot.model.NamedShadowIndexingMode;
import software.amazon.awssdk.services.iot.model.ThingConnectivityIndexingMode;
import software.amazon.awssdk.services.iot.model.ThingIndexingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThingIndexingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThingIndexingConfiguration> {
    private static final SdkField<String> THING_INDEXING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingIndexingMode").getter(ThingIndexingConfiguration.getter(ThingIndexingConfiguration::thingIndexingModeAsString)).setter(ThingIndexingConfiguration.setter(Builder::thingIndexingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingIndexingMode").build()}).build();
    private static final SdkField<String> THING_CONNECTIVITY_INDEXING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingConnectivityIndexingMode").getter(ThingIndexingConfiguration.getter(ThingIndexingConfiguration::thingConnectivityIndexingModeAsString)).setter(ThingIndexingConfiguration.setter(Builder::thingConnectivityIndexingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingConnectivityIndexingMode").build()}).build();
    private static final SdkField<String> DEVICE_DEFENDER_INDEXING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceDefenderIndexingMode").getter(ThingIndexingConfiguration.getter(ThingIndexingConfiguration::deviceDefenderIndexingModeAsString)).setter(ThingIndexingConfiguration.setter(Builder::deviceDefenderIndexingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceDefenderIndexingMode").build()}).build();
    private static final SdkField<String> NAMED_SHADOW_INDEXING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namedShadowIndexingMode").getter(ThingIndexingConfiguration.getter(ThingIndexingConfiguration::namedShadowIndexingModeAsString)).setter(ThingIndexingConfiguration.setter(Builder::namedShadowIndexingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namedShadowIndexingMode").build()}).build();
    private static final SdkField<List<Field>> MANAGED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managedFields").getter(ThingIndexingConfiguration.getter(ThingIndexingConfiguration::managedFields)).setter(ThingIndexingConfiguration.setter(Builder::managedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Field::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Field>> CUSTOM_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customFields").getter(ThingIndexingConfiguration.getter(ThingIndexingConfiguration::customFields)).setter(ThingIndexingConfiguration.setter(Builder::customFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Field::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_INDEXING_MODE_FIELD, THING_CONNECTIVITY_INDEXING_MODE_FIELD, DEVICE_DEFENDER_INDEXING_MODE_FIELD, NAMED_SHADOW_INDEXING_MODE_FIELD, MANAGED_FIELDS_FIELD, CUSTOM_FIELDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String thingIndexingMode;
    private final String thingConnectivityIndexingMode;
    private final String deviceDefenderIndexingMode;
    private final String namedShadowIndexingMode;
    private final List<Field> managedFields;
    private final List<Field> customFields;

    private ThingIndexingConfiguration(BuilderImpl builder) {
        this.thingIndexingMode = builder.thingIndexingMode;
        this.thingConnectivityIndexingMode = builder.thingConnectivityIndexingMode;
        this.deviceDefenderIndexingMode = builder.deviceDefenderIndexingMode;
        this.namedShadowIndexingMode = builder.namedShadowIndexingMode;
        this.managedFields = builder.managedFields;
        this.customFields = builder.customFields;
    }

    public final ThingIndexingMode thingIndexingMode() {
        return ThingIndexingMode.fromValue(this.thingIndexingMode);
    }

    public final String thingIndexingModeAsString() {
        return this.thingIndexingMode;
    }

    public final ThingConnectivityIndexingMode thingConnectivityIndexingMode() {
        return ThingConnectivityIndexingMode.fromValue(this.thingConnectivityIndexingMode);
    }

    public final String thingConnectivityIndexingModeAsString() {
        return this.thingConnectivityIndexingMode;
    }

    public final DeviceDefenderIndexingMode deviceDefenderIndexingMode() {
        return DeviceDefenderIndexingMode.fromValue(this.deviceDefenderIndexingMode);
    }

    public final String deviceDefenderIndexingModeAsString() {
        return this.deviceDefenderIndexingMode;
    }

    public final NamedShadowIndexingMode namedShadowIndexingMode() {
        return NamedShadowIndexingMode.fromValue(this.namedShadowIndexingMode);
    }

    public final String namedShadowIndexingModeAsString() {
        return this.namedShadowIndexingMode;
    }

    public final boolean hasManagedFields() {
        return this.managedFields != null && !(this.managedFields instanceof SdkAutoConstructList);
    }

    public final List<Field> managedFields() {
        return this.managedFields;
    }

    public final boolean hasCustomFields() {
        return this.customFields != null && !(this.customFields instanceof SdkAutoConstructList);
    }

    public final List<Field> customFields() {
        return this.customFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingIndexingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingConnectivityIndexingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceDefenderIndexingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namedShadowIndexingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedFields() ? this.managedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomFields() ? this.customFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingIndexingConfiguration)) {
            return false;
        }
        ThingIndexingConfiguration other = (ThingIndexingConfiguration)obj;
        return Objects.equals(this.thingIndexingModeAsString(), other.thingIndexingModeAsString()) && Objects.equals(this.thingConnectivityIndexingModeAsString(), other.thingConnectivityIndexingModeAsString()) && Objects.equals(this.deviceDefenderIndexingModeAsString(), other.deviceDefenderIndexingModeAsString()) && Objects.equals(this.namedShadowIndexingModeAsString(), other.namedShadowIndexingModeAsString()) && this.hasManagedFields() == other.hasManagedFields() && Objects.equals(this.managedFields(), other.managedFields()) && this.hasCustomFields() == other.hasCustomFields() && Objects.equals(this.customFields(), other.customFields());
    }

    public final String toString() {
        return ToString.builder((String)"ThingIndexingConfiguration").add("ThingIndexingMode", (Object)this.thingIndexingModeAsString()).add("ThingConnectivityIndexingMode", (Object)this.thingConnectivityIndexingModeAsString()).add("DeviceDefenderIndexingMode", (Object)this.deviceDefenderIndexingModeAsString()).add("NamedShadowIndexingMode", (Object)this.namedShadowIndexingModeAsString()).add("ManagedFields", this.hasManagedFields() ? this.managedFields() : null).add("CustomFields", this.hasCustomFields() ? this.customFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingIndexingMode": {
                return Optional.ofNullable(clazz.cast(this.thingIndexingModeAsString()));
            }
            case "thingConnectivityIndexingMode": {
                return Optional.ofNullable(clazz.cast(this.thingConnectivityIndexingModeAsString()));
            }
            case "deviceDefenderIndexingMode": {
                return Optional.ofNullable(clazz.cast(this.deviceDefenderIndexingModeAsString()));
            }
            case "namedShadowIndexingMode": {
                return Optional.ofNullable(clazz.cast(this.namedShadowIndexingModeAsString()));
            }
            case "managedFields": {
                return Optional.ofNullable(clazz.cast(this.managedFields()));
            }
            case "customFields": {
                return Optional.ofNullable(clazz.cast(this.customFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingIndexingConfiguration, T> g) {
        return obj -> g.apply((ThingIndexingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingIndexingMode;
        private String thingConnectivityIndexingMode;
        private String deviceDefenderIndexingMode;
        private String namedShadowIndexingMode;
        private List<Field> managedFields = DefaultSdkAutoConstructList.getInstance();
        private List<Field> customFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ThingIndexingConfiguration model) {
            this.thingIndexingMode(model.thingIndexingMode);
            this.thingConnectivityIndexingMode(model.thingConnectivityIndexingMode);
            this.deviceDefenderIndexingMode(model.deviceDefenderIndexingMode);
            this.namedShadowIndexingMode(model.namedShadowIndexingMode);
            this.managedFields(model.managedFields);
            this.customFields(model.customFields);
        }

        public final String getThingIndexingMode() {
            return this.thingIndexingMode;
        }

        public final void setThingIndexingMode(String thingIndexingMode) {
            this.thingIndexingMode = thingIndexingMode;
        }

        @Override
        @Transient
        public final Builder thingIndexingMode(String thingIndexingMode) {
            this.thingIndexingMode = thingIndexingMode;
            return this;
        }

        @Override
        @Transient
        public final Builder thingIndexingMode(ThingIndexingMode thingIndexingMode) {
            this.thingIndexingMode(thingIndexingMode == null ? null : thingIndexingMode.toString());
            return this;
        }

        public final String getThingConnectivityIndexingMode() {
            return this.thingConnectivityIndexingMode;
        }

        public final void setThingConnectivityIndexingMode(String thingConnectivityIndexingMode) {
            this.thingConnectivityIndexingMode = thingConnectivityIndexingMode;
        }

        @Override
        @Transient
        public final Builder thingConnectivityIndexingMode(String thingConnectivityIndexingMode) {
            this.thingConnectivityIndexingMode = thingConnectivityIndexingMode;
            return this;
        }

        @Override
        @Transient
        public final Builder thingConnectivityIndexingMode(ThingConnectivityIndexingMode thingConnectivityIndexingMode) {
            this.thingConnectivityIndexingMode(thingConnectivityIndexingMode == null ? null : thingConnectivityIndexingMode.toString());
            return this;
        }

        public final String getDeviceDefenderIndexingMode() {
            return this.deviceDefenderIndexingMode;
        }

        public final void setDeviceDefenderIndexingMode(String deviceDefenderIndexingMode) {
            this.deviceDefenderIndexingMode = deviceDefenderIndexingMode;
        }

        @Override
        @Transient
        public final Builder deviceDefenderIndexingMode(String deviceDefenderIndexingMode) {
            this.deviceDefenderIndexingMode = deviceDefenderIndexingMode;
            return this;
        }

        @Override
        @Transient
        public final Builder deviceDefenderIndexingMode(DeviceDefenderIndexingMode deviceDefenderIndexingMode) {
            this.deviceDefenderIndexingMode(deviceDefenderIndexingMode == null ? null : deviceDefenderIndexingMode.toString());
            return this;
        }

        public final String getNamedShadowIndexingMode() {
            return this.namedShadowIndexingMode;
        }

        public final void setNamedShadowIndexingMode(String namedShadowIndexingMode) {
            this.namedShadowIndexingMode = namedShadowIndexingMode;
        }

        @Override
        @Transient
        public final Builder namedShadowIndexingMode(String namedShadowIndexingMode) {
            this.namedShadowIndexingMode = namedShadowIndexingMode;
            return this;
        }

        @Override
        @Transient
        public final Builder namedShadowIndexingMode(NamedShadowIndexingMode namedShadowIndexingMode) {
            this.namedShadowIndexingMode(namedShadowIndexingMode == null ? null : namedShadowIndexingMode.toString());
            return this;
        }

        public final List<Field.Builder> getManagedFields() {
            List<Field.Builder> result = FieldsCopier.copyToBuilder(this.managedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedFields(Collection<Field.BuilderImpl> managedFields) {
            this.managedFields = FieldsCopier.copyFromBuilder(managedFields);
        }

        @Override
        @Transient
        public final Builder managedFields(Collection<Field> managedFields) {
            this.managedFields = FieldsCopier.copy(managedFields);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder managedFields(Field ... managedFields) {
            this.managedFields(Arrays.asList(managedFields));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder managedFields(Consumer<Field.Builder> ... managedFields) {
            this.managedFields(Stream.of(managedFields).map(c -> (Field)((Field.Builder)Field.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Field.Builder> getCustomFields() {
            List<Field.Builder> result = FieldsCopier.copyToBuilder(this.customFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomFields(Collection<Field.BuilderImpl> customFields) {
            this.customFields = FieldsCopier.copyFromBuilder(customFields);
        }

        @Override
        @Transient
        public final Builder customFields(Collection<Field> customFields) {
            this.customFields = FieldsCopier.copy(customFields);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder customFields(Field ... customFields) {
            this.customFields(Arrays.asList(customFields));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder customFields(Consumer<Field.Builder> ... customFields) {
            this.customFields(Stream.of(customFields).map(c -> (Field)((Field.Builder)Field.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ThingIndexingConfiguration build() {
            return new ThingIndexingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThingIndexingConfiguration> {
        public Builder thingIndexingMode(String var1);

        public Builder thingIndexingMode(ThingIndexingMode var1);

        public Builder thingConnectivityIndexingMode(String var1);

        public Builder thingConnectivityIndexingMode(ThingConnectivityIndexingMode var1);

        public Builder deviceDefenderIndexingMode(String var1);

        public Builder deviceDefenderIndexingMode(DeviceDefenderIndexingMode var1);

        public Builder namedShadowIndexingMode(String var1);

        public Builder namedShadowIndexingMode(NamedShadowIndexingMode var1);

        public Builder managedFields(Collection<Field> var1);

        public Builder managedFields(Field ... var1);

        public Builder managedFields(Consumer<Field.Builder> ... var1);

        public Builder customFields(Collection<Field> var1);

        public Builder customFields(Field ... var1);

        public Builder customFields(Consumer<Field.Builder> ... var1);
    }
}

