/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.HttpUrlDestinationConfiguration;
import software.amazon.awssdk.services.iot.model.VpcDestinationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicRuleDestinationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicRuleDestinationConfiguration> {
    private static final SdkField<HttpUrlDestinationConfiguration> HTTP_URL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("httpUrlConfiguration").getter(TopicRuleDestinationConfiguration.getter(TopicRuleDestinationConfiguration::httpUrlConfiguration)).setter(TopicRuleDestinationConfiguration.setter(Builder::httpUrlConfiguration)).constructor(HttpUrlDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpUrlConfiguration").build()}).build();
    private static final SdkField<VpcDestinationConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfiguration").getter(TopicRuleDestinationConfiguration.getter(TopicRuleDestinationConfiguration::vpcConfiguration)).setter(TopicRuleDestinationConfiguration.setter(Builder::vpcConfiguration)).constructor(VpcDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_URL_CONFIGURATION_FIELD, VPC_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final HttpUrlDestinationConfiguration httpUrlConfiguration;
    private final VpcDestinationConfiguration vpcConfiguration;

    private TopicRuleDestinationConfiguration(BuilderImpl builder) {
        this.httpUrlConfiguration = builder.httpUrlConfiguration;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    public final HttpUrlDestinationConfiguration httpUrlConfiguration() {
        return this.httpUrlConfiguration;
    }

    public final VpcDestinationConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpUrlConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRuleDestinationConfiguration)) {
            return false;
        }
        TopicRuleDestinationConfiguration other = (TopicRuleDestinationConfiguration)obj;
        return Objects.equals(this.httpUrlConfiguration(), other.httpUrlConfiguration()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"TopicRuleDestinationConfiguration").add("HttpUrlConfiguration", (Object)this.httpUrlConfiguration()).add("VpcConfiguration", (Object)this.vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "httpUrlConfiguration": {
                return Optional.ofNullable(clazz.cast(this.httpUrlConfiguration()));
            }
            case "vpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicRuleDestinationConfiguration, T> g) {
        return obj -> g.apply((TopicRuleDestinationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HttpUrlDestinationConfiguration httpUrlConfiguration;
        private VpcDestinationConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRuleDestinationConfiguration model) {
            this.httpUrlConfiguration(model.httpUrlConfiguration);
            this.vpcConfiguration(model.vpcConfiguration);
        }

        public final HttpUrlDestinationConfiguration.Builder getHttpUrlConfiguration() {
            return this.httpUrlConfiguration != null ? this.httpUrlConfiguration.toBuilder() : null;
        }

        public final void setHttpUrlConfiguration(HttpUrlDestinationConfiguration.BuilderImpl httpUrlConfiguration) {
            this.httpUrlConfiguration = httpUrlConfiguration != null ? httpUrlConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder httpUrlConfiguration(HttpUrlDestinationConfiguration httpUrlConfiguration) {
            this.httpUrlConfiguration = httpUrlConfiguration;
            return this;
        }

        public final VpcDestinationConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcDestinationConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder vpcConfiguration(VpcDestinationConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public TopicRuleDestinationConfiguration build() {
            return new TopicRuleDestinationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicRuleDestinationConfiguration> {
        public Builder httpUrlConfiguration(HttpUrlDestinationConfiguration var1);

        default public Builder httpUrlConfiguration(Consumer<HttpUrlDestinationConfiguration.Builder> httpUrlConfiguration) {
            return this.httpUrlConfiguration((HttpUrlDestinationConfiguration)((HttpUrlDestinationConfiguration.Builder)HttpUrlDestinationConfiguration.builder().applyMutation(httpUrlConfiguration)).build());
        }

        public Builder vpcConfiguration(VpcDestinationConfiguration var1);

        default public Builder vpcConfiguration(Consumer<VpcDestinationConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((VpcDestinationConfiguration)((VpcDestinationConfiguration.Builder)VpcDestinationConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }
    }
}

