/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest;
import software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse;
import software.amazon.awssdk.services.iot.model.OTAUpdateSummary;

public class ListOTAUpdatesIterable
implements SdkIterable<ListOtaUpdatesResponse> {
    private final IotClient client;
    private final ListOtaUpdatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOTAUpdatesIterable(IotClient client, ListOtaUpdatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOtaUpdatesResponseFetcher();
    }

    public Iterator<ListOtaUpdatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OTAUpdateSummary> otaUpdates() {
        Function<ListOtaUpdatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.otaUpdates() != null) {
                return response.otaUpdates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOtaUpdatesResponseFetcher
    implements SyncPageFetcher<ListOtaUpdatesResponse> {
        private ListOtaUpdatesResponseFetcher() {
        }

        public boolean hasNextPage(ListOtaUpdatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOtaUpdatesResponse nextPage(ListOtaUpdatesResponse previousPage) {
            if (previousPage == null) {
                return ListOTAUpdatesIterable.this.client.listOTAUpdates(ListOTAUpdatesIterable.this.firstRequest);
            }
            return ListOTAUpdatesIterable.this.client.listOTAUpdates((ListOtaUpdatesRequest)((Object)ListOTAUpdatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

