/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ResourceIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAuditSuppressionsRequest
extends IotRequest
implements ToCopyableBuilder<Builder, ListAuditSuppressionsRequest> {
    private static final SdkField<String> CHECK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checkName").getter(ListAuditSuppressionsRequest.getter(ListAuditSuppressionsRequest::checkName)).setter(ListAuditSuppressionsRequest.setter(Builder::checkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkName").build()}).build();
    private static final SdkField<ResourceIdentifier> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceIdentifier").getter(ListAuditSuppressionsRequest.getter(ListAuditSuppressionsRequest::resourceIdentifier)).setter(ListAuditSuppressionsRequest.setter(Builder::resourceIdentifier)).constructor(ResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build()}).build();
    private static final SdkField<Boolean> ASCENDING_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ascendingOrder").getter(ListAuditSuppressionsRequest.getter(ListAuditSuppressionsRequest::ascendingOrder)).setter(ListAuditSuppressionsRequest.setter(Builder::ascendingOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ascendingOrder").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAuditSuppressionsRequest.getter(ListAuditSuppressionsRequest::nextToken)).setter(ListAuditSuppressionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAuditSuppressionsRequest.getter(ListAuditSuppressionsRequest::maxResults)).setter(ListAuditSuppressionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_NAME_FIELD, RESOURCE_IDENTIFIER_FIELD, ASCENDING_ORDER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String checkName;
    private final ResourceIdentifier resourceIdentifier;
    private final Boolean ascendingOrder;
    private final String nextToken;
    private final Integer maxResults;

    private ListAuditSuppressionsRequest(BuilderImpl builder) {
        super(builder);
        this.checkName = builder.checkName;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.ascendingOrder = builder.ascendingOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String checkName() {
        return this.checkName;
    }

    public final ResourceIdentifier resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final Boolean ascendingOrder() {
        return this.ascendingOrder;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.checkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.ascendingOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditSuppressionsRequest)) {
            return false;
        }
        ListAuditSuppressionsRequest other = (ListAuditSuppressionsRequest)((Object)obj);
        return Objects.equals(this.checkName(), other.checkName()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.ascendingOrder(), other.ascendingOrder()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListAuditSuppressionsRequest").add("CheckName", (Object)this.checkName()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("AscendingOrder", (Object)this.ascendingOrder()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "checkName": {
                return Optional.ofNullable(clazz.cast(this.checkName()));
            }
            case "resourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "ascendingOrder": {
                return Optional.ofNullable(clazz.cast(this.ascendingOrder()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAuditSuppressionsRequest, T> g) {
        return obj -> g.apply((ListAuditSuppressionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String checkName;
        private ResourceIdentifier resourceIdentifier;
        private Boolean ascendingOrder;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditSuppressionsRequest model) {
            super(model);
            this.checkName(model.checkName);
            this.resourceIdentifier(model.resourceIdentifier);
            this.ascendingOrder(model.ascendingOrder);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getCheckName() {
            return this.checkName;
        }

        public final void setCheckName(String checkName) {
            this.checkName = checkName;
        }

        @Override
        @Transient
        public final Builder checkName(String checkName) {
            this.checkName = checkName;
            return this;
        }

        public final ResourceIdentifier.Builder getResourceIdentifier() {
            return this.resourceIdentifier != null ? this.resourceIdentifier.toBuilder() : null;
        }

        public final void setResourceIdentifier(ResourceIdentifier.BuilderImpl resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier != null ? resourceIdentifier.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceIdentifier(ResourceIdentifier resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final Boolean getAscendingOrder() {
            return this.ascendingOrder;
        }

        public final void setAscendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
        }

        @Override
        @Transient
        public final Builder ascendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAuditSuppressionsRequest build() {
            return new ListAuditSuppressionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAuditSuppressionsRequest> {
        public Builder checkName(String var1);

        public Builder resourceIdentifier(ResourceIdentifier var1);

        default public Builder resourceIdentifier(Consumer<ResourceIdentifier.Builder> resourceIdentifier) {
            return this.resourceIdentifier((ResourceIdentifier)((ResourceIdentifier.Builder)ResourceIdentifier.builder().applyMutation(resourceIdentifier)).build());
        }

        public Builder ascendingOrder(Boolean var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

