/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.AggregationType;
import software.amazon.awssdk.services.iot.model.FleetMetricUnit;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetMetricResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeFleetMetricResponse> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(DescribeFleetMetricResponse.getter(DescribeFleetMetricResponse::metricName)).setter(DescribeFleetMetricResponse.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryString").getter(DescribeFleetMetricResponse.getter(DescribeFleetMetricResponse::queryString)).setter(DescribeFleetMetricResponse.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()}).build();
    private static final SdkField<AggregationType> AGGREGATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregationType").getter(DescribeFleetMetricResponse.getter(DescribeFleetMetricResponse::aggregationType)).setter(DescribeFleetMetricResponse.setter(Builder::aggregationType)).constructor(AggregationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationType").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("period").getter(DescribeFleetMetricResponse.getter(DescribeFleetMetricResponse::period)).setter(DescribeFleetMetricResponse.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final SdkField<String> AGGREGATION_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregationField").getter(DescribeFleetMetricResponse.getter(DescribeFleetMetricResponse::aggregationField)).setter(DescribeFleetMetricResponse.setter(Builder::aggregationField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationField").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DescribeFleetMetricResponse.getter(DescribeFleetMetricResponse::description)).setter(DescribeFleetMetricResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> QUERY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryVersion").getter(DescribeFleetMetricResponse.getter(DescribeFleetMetricResponse::queryVersion)).setter(DescribeFleetMetricResponse.setter(Builder::queryVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryVersion").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexName").getter(DescribeFleetMetricResponse.getter(DescribeFleetMetricResponse::indexName)).setter(DescribeFleetMetricResponse.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(DescribeFleetMetricResponse.getter(DescribeFleetMetricResponse::creationDate)).setter(DescribeFleetMetricResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(DescribeFleetMetricResponse.getter(DescribeFleetMetricResponse::lastModifiedDate)).setter(DescribeFleetMetricResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(DescribeFleetMetricResponse.getter(DescribeFleetMetricResponse::unitAsString)).setter(DescribeFleetMetricResponse.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("version").getter(DescribeFleetMetricResponse.getter(DescribeFleetMetricResponse::version)).setter(DescribeFleetMetricResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> METRIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricArn").getter(DescribeFleetMetricResponse.getter(DescribeFleetMetricResponse::metricArn)).setter(DescribeFleetMetricResponse.setter(Builder::metricArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, QUERY_STRING_FIELD, AGGREGATION_TYPE_FIELD, PERIOD_FIELD, AGGREGATION_FIELD_FIELD, DESCRIPTION_FIELD, QUERY_VERSION_FIELD, INDEX_NAME_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, UNIT_FIELD, VERSION_FIELD, METRIC_ARN_FIELD));
    private final String metricName;
    private final String queryString;
    private final AggregationType aggregationType;
    private final Integer period;
    private final String aggregationField;
    private final String description;
    private final String queryVersion;
    private final String indexName;
    private final Instant creationDate;
    private final Instant lastModifiedDate;
    private final String unit;
    private final Long version;
    private final String metricArn;

    private DescribeFleetMetricResponse(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.queryString = builder.queryString;
        this.aggregationType = builder.aggregationType;
        this.period = builder.period;
        this.aggregationField = builder.aggregationField;
        this.description = builder.description;
        this.queryVersion = builder.queryVersion;
        this.indexName = builder.indexName;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.unit = builder.unit;
        this.version = builder.version;
        this.metricArn = builder.metricArn;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final AggregationType aggregationType() {
        return this.aggregationType;
    }

    public final Integer period() {
        return this.period;
    }

    public final String aggregationField() {
        return this.aggregationField;
    }

    public final String description() {
        return this.description;
    }

    public final String queryVersion() {
        return this.queryVersion;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final FleetMetricUnit unit() {
        return FleetMetricUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public final Long version() {
        return this.version;
    }

    public final String metricArn() {
        return this.metricArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationField());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetMetricResponse)) {
            return false;
        }
        DescribeFleetMetricResponse other = (DescribeFleetMetricResponse)((Object)obj);
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.aggregationType(), other.aggregationType()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.aggregationField(), other.aggregationField()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.queryVersion(), other.queryVersion()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.metricArn(), other.metricArn());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFleetMetricResponse").add("MetricName", (Object)this.metricName()).add("QueryString", (Object)this.queryString()).add("AggregationType", (Object)this.aggregationType()).add("Period", (Object)this.period()).add("AggregationField", (Object)this.aggregationField()).add("Description", (Object)this.description()).add("QueryVersion", (Object)this.queryVersion()).add("IndexName", (Object)this.indexName()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Unit", (Object)this.unitAsString()).add("Version", (Object)this.version()).add("MetricArn", (Object)this.metricArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "aggregationType": {
                return Optional.ofNullable(clazz.cast(this.aggregationType()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "aggregationField": {
                return Optional.ofNullable(clazz.cast(this.aggregationField()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "queryVersion": {
                return Optional.ofNullable(clazz.cast(this.queryVersion()));
            }
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "metricArn": {
                return Optional.ofNullable(clazz.cast(this.metricArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetMetricResponse, T> g) {
        return obj -> g.apply((DescribeFleetMetricResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String metricName;
        private String queryString;
        private AggregationType aggregationType;
        private Integer period;
        private String aggregationField;
        private String description;
        private String queryVersion;
        private String indexName;
        private Instant creationDate;
        private Instant lastModifiedDate;
        private String unit;
        private Long version;
        private String metricArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetMetricResponse model) {
            super(model);
            this.metricName(model.metricName);
            this.queryString(model.queryString);
            this.aggregationType(model.aggregationType);
            this.period(model.period);
            this.aggregationField(model.aggregationField);
            this.description(model.description);
            this.queryVersion(model.queryVersion);
            this.indexName(model.indexName);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
            this.unit(model.unit);
            this.version(model.version);
            this.metricArn(model.metricArn);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        @Transient
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        @Transient
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final AggregationType.Builder getAggregationType() {
            return this.aggregationType != null ? this.aggregationType.toBuilder() : null;
        }

        public final void setAggregationType(AggregationType.BuilderImpl aggregationType) {
            this.aggregationType = aggregationType != null ? aggregationType.build() : null;
        }

        @Override
        @Transient
        public final Builder aggregationType(AggregationType aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        @Transient
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getAggregationField() {
            return this.aggregationField;
        }

        public final void setAggregationField(String aggregationField) {
            this.aggregationField = aggregationField;
        }

        @Override
        @Transient
        public final Builder aggregationField(String aggregationField) {
            this.aggregationField = aggregationField;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getQueryVersion() {
            return this.queryVersion;
        }

        public final void setQueryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
        }

        @Override
        @Transient
        public final Builder queryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        @Transient
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        @Transient
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        @Transient
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        @Transient
        public final Builder unit(FleetMetricUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Long getVersion() {
            return this.version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getMetricArn() {
            return this.metricArn;
        }

        public final void setMetricArn(String metricArn) {
            this.metricArn = metricArn;
        }

        @Override
        @Transient
        public final Builder metricArn(String metricArn) {
            this.metricArn = metricArn;
            return this;
        }

        @Override
        public DescribeFleetMetricResponse build() {
            return new DescribeFleetMetricResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFleetMetricResponse> {
        public Builder metricName(String var1);

        public Builder queryString(String var1);

        public Builder aggregationType(AggregationType var1);

        default public Builder aggregationType(Consumer<AggregationType.Builder> aggregationType) {
            return this.aggregationType((AggregationType)((AggregationType.Builder)AggregationType.builder().applyMutation(aggregationType)).build());
        }

        public Builder period(Integer var1);

        public Builder aggregationField(String var1);

        public Builder description(String var1);

        public Builder queryVersion(String var1);

        public Builder indexName(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder unit(String var1);

        public Builder unit(FleetMetricUnit var1);

        public Builder version(Long var1);

        public Builder metricArn(String var1);
    }
}

