/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListThingsInThingGroupRequest;
import software.amazon.awssdk.services.iot.model.ListThingsInThingGroupResponse;

public class ListThingsInThingGroupIterable
implements SdkIterable<ListThingsInThingGroupResponse> {
    private final IotClient client;
    private final ListThingsInThingGroupRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThingsInThingGroupIterable(IotClient client, ListThingsInThingGroupRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListThingsInThingGroupResponseFetcher();
    }

    public Iterator<ListThingsInThingGroupResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> things() {
        Function<ListThingsInThingGroupResponse, Iterator> getIterator = response -> {
            if (response != null && response.things() != null) {
                return response.things().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListThingsInThingGroupResponseFetcher
    implements SyncPageFetcher<ListThingsInThingGroupResponse> {
        private ListThingsInThingGroupResponseFetcher() {
        }

        public boolean hasNextPage(ListThingsInThingGroupResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListThingsInThingGroupResponse nextPage(ListThingsInThingGroupResponse previousPage) {
            if (previousPage == null) {
                return ListThingsInThingGroupIterable.this.client.listThingsInThingGroup(ListThingsInThingGroupIterable.this.firstRequest);
            }
            return ListThingsInThingGroupIterable.this.client.listThingsInThingGroup((ListThingsInThingGroupRequest)((Object)ListThingsInThingGroupIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

