/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyVersion> {
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionId").getter(PolicyVersion.getter(PolicyVersion::versionId)).setter(PolicyVersion.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionId").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isDefaultVersion").getter(PolicyVersion.getter(PolicyVersion::isDefaultVersion)).setter(PolicyVersion.setter(Builder::isDefaultVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDefaultVersion").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createDate").getter(PolicyVersion.getter(PolicyVersion::createDate)).setter(PolicyVersion.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_ID_FIELD, IS_DEFAULT_VERSION_FIELD, CREATE_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String versionId;
    private final Boolean isDefaultVersion;
    private final Instant createDate;

    private PolicyVersion(BuilderImpl builder) {
        this.versionId = builder.versionId;
        this.isDefaultVersion = builder.isDefaultVersion;
        this.createDate = builder.createDate;
    }

    public final String versionId() {
        return this.versionId;
    }

    public final Boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyVersion)) {
            return false;
        }
        PolicyVersion other = (PolicyVersion)obj;
        return Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.isDefaultVersion(), other.isDefaultVersion()) && Objects.equals(this.createDate(), other.createDate());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyVersion").add("VersionId", (Object)this.versionId()).add("IsDefaultVersion", (Object)this.isDefaultVersion()).add("CreateDate", (Object)this.createDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "versionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "isDefaultVersion": {
                return Optional.ofNullable(clazz.cast(this.isDefaultVersion()));
            }
            case "createDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyVersion, T> g) {
        return obj -> g.apply((PolicyVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String versionId;
        private Boolean isDefaultVersion;
        private Instant createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyVersion model) {
            this.versionId(model.versionId);
            this.isDefaultVersion(model.isDefaultVersion);
            this.createDate(model.createDate);
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final Boolean getIsDefaultVersion() {
            return this.isDefaultVersion;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public PolicyVersion build() {
            return new PolicyVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyVersion> {
        public Builder versionId(String var1);

        public Builder isDefaultVersion(Boolean var1);

        public Builder createDate(Instant var1);
    }
}

