/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.HttpContext;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.MqttContext;
import software.amazon.awssdk.services.iot.model.TlsContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestInvokeAuthorizerRequest
extends IotRequest
implements ToCopyableBuilder<Builder, TestInvokeAuthorizerRequest> {
    private static final SdkField<String> AUTHORIZER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizerName").getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::authorizerName)).setter(TestInvokeAuthorizerRequest.setter(Builder::authorizerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("authorizerName").build()}).build();
    private static final SdkField<String> TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("token").getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::token)).setter(TestInvokeAuthorizerRequest.setter(Builder::token)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()}).build();
    private static final SdkField<String> TOKEN_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenSignature").getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::tokenSignature)).setter(TestInvokeAuthorizerRequest.setter(Builder::tokenSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenSignature").build()}).build();
    private static final SdkField<HttpContext> HTTP_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("httpContext").getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::httpContext)).setter(TestInvokeAuthorizerRequest.setter(Builder::httpContext)).constructor(HttpContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpContext").build()}).build();
    private static final SdkField<MqttContext> MQTT_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("mqttContext").getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::mqttContext)).setter(TestInvokeAuthorizerRequest.setter(Builder::mqttContext)).constructor(MqttContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mqttContext").build()}).build();
    private static final SdkField<TlsContext> TLS_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tlsContext").getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::tlsContext)).setter(TestInvokeAuthorizerRequest.setter(Builder::tlsContext)).constructor(TlsContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZER_NAME_FIELD, TOKEN_FIELD, TOKEN_SIGNATURE_FIELD, HTTP_CONTEXT_FIELD, MQTT_CONTEXT_FIELD, TLS_CONTEXT_FIELD));
    private final String authorizerName;
    private final String token;
    private final String tokenSignature;
    private final HttpContext httpContext;
    private final MqttContext mqttContext;
    private final TlsContext tlsContext;

    private TestInvokeAuthorizerRequest(BuilderImpl builder) {
        super(builder);
        this.authorizerName = builder.authorizerName;
        this.token = builder.token;
        this.tokenSignature = builder.tokenSignature;
        this.httpContext = builder.httpContext;
        this.mqttContext = builder.mqttContext;
        this.tlsContext = builder.tlsContext;
    }

    public final String authorizerName() {
        return this.authorizerName;
    }

    public final String token() {
        return this.token;
    }

    public final String tokenSignature() {
        return this.tokenSignature;
    }

    public final HttpContext httpContext() {
        return this.httpContext;
    }

    public final MqttContext mqttContext() {
        return this.mqttContext;
    }

    public final TlsContext tlsContext() {
        return this.tlsContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenSignature());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.mqttContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeAuthorizerRequest)) {
            return false;
        }
        TestInvokeAuthorizerRequest other = (TestInvokeAuthorizerRequest)((Object)obj);
        return Objects.equals(this.authorizerName(), other.authorizerName()) && Objects.equals(this.token(), other.token()) && Objects.equals(this.tokenSignature(), other.tokenSignature()) && Objects.equals(this.httpContext(), other.httpContext()) && Objects.equals(this.mqttContext(), other.mqttContext()) && Objects.equals(this.tlsContext(), other.tlsContext());
    }

    public final String toString() {
        return ToString.builder((String)"TestInvokeAuthorizerRequest").add("AuthorizerName", (Object)this.authorizerName()).add("Token", (Object)this.token()).add("TokenSignature", (Object)this.tokenSignature()).add("HttpContext", (Object)this.httpContext()).add("MqttContext", (Object)this.mqttContext()).add("TlsContext", (Object)this.tlsContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizerName": {
                return Optional.ofNullable(clazz.cast(this.authorizerName()));
            }
            case "token": {
                return Optional.ofNullable(clazz.cast(this.token()));
            }
            case "tokenSignature": {
                return Optional.ofNullable(clazz.cast(this.tokenSignature()));
            }
            case "httpContext": {
                return Optional.ofNullable(clazz.cast(this.httpContext()));
            }
            case "mqttContext": {
                return Optional.ofNullable(clazz.cast(this.mqttContext()));
            }
            case "tlsContext": {
                return Optional.ofNullable(clazz.cast(this.tlsContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestInvokeAuthorizerRequest, T> g) {
        return obj -> g.apply((TestInvokeAuthorizerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String authorizerName;
        private String token;
        private String tokenSignature;
        private HttpContext httpContext;
        private MqttContext mqttContext;
        private TlsContext tlsContext;

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeAuthorizerRequest model) {
            super(model);
            this.authorizerName(model.authorizerName);
            this.token(model.token);
            this.tokenSignature(model.tokenSignature);
            this.httpContext(model.httpContext);
            this.mqttContext(model.mqttContext);
            this.tlsContext(model.tlsContext);
        }

        public final String getAuthorizerName() {
            return this.authorizerName;
        }

        public final void setAuthorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
        }

        @Override
        public final Builder authorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        public final String getToken() {
            return this.token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final String getTokenSignature() {
            return this.tokenSignature;
        }

        public final void setTokenSignature(String tokenSignature) {
            this.tokenSignature = tokenSignature;
        }

        @Override
        public final Builder tokenSignature(String tokenSignature) {
            this.tokenSignature = tokenSignature;
            return this;
        }

        public final HttpContext.Builder getHttpContext() {
            return this.httpContext != null ? this.httpContext.toBuilder() : null;
        }

        public final void setHttpContext(HttpContext.BuilderImpl httpContext) {
            this.httpContext = httpContext != null ? httpContext.build() : null;
        }

        @Override
        public final Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public final MqttContext.Builder getMqttContext() {
            return this.mqttContext != null ? this.mqttContext.toBuilder() : null;
        }

        public final void setMqttContext(MqttContext.BuilderImpl mqttContext) {
            this.mqttContext = mqttContext != null ? mqttContext.build() : null;
        }

        @Override
        public final Builder mqttContext(MqttContext mqttContext) {
            this.mqttContext = mqttContext;
            return this;
        }

        public final TlsContext.Builder getTlsContext() {
            return this.tlsContext != null ? this.tlsContext.toBuilder() : null;
        }

        public final void setTlsContext(TlsContext.BuilderImpl tlsContext) {
            this.tlsContext = tlsContext != null ? tlsContext.build() : null;
        }

        @Override
        public final Builder tlsContext(TlsContext tlsContext) {
            this.tlsContext = tlsContext;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestInvokeAuthorizerRequest build() {
            return new TestInvokeAuthorizerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestInvokeAuthorizerRequest> {
        public Builder authorizerName(String var1);

        public Builder token(String var1);

        public Builder tokenSignature(String var1);

        public Builder httpContext(HttpContext var1);

        default public Builder httpContext(Consumer<HttpContext.Builder> httpContext) {
            return this.httpContext((HttpContext)((HttpContext.Builder)HttpContext.builder().applyMutation(httpContext)).build());
        }

        public Builder mqttContext(MqttContext var1);

        default public Builder mqttContext(Consumer<MqttContext.Builder> mqttContext) {
            return this.mqttContext((MqttContext)((MqttContext.Builder)MqttContext.builder().applyMutation(mqttContext)).build());
        }

        public Builder tlsContext(TlsContext var1);

        default public Builder tlsContext(Consumer<TlsContext.Builder> tlsContext) {
            return this.tlsContext((TlsContext)((TlsContext.Builder)TlsContext.builder().applyMutation(tlsContext)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

