/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListCustomMetricsRequest;
import software.amazon.awssdk.services.iot.model.ListCustomMetricsResponse;

public class ListCustomMetricsPublisher
implements SdkPublisher<ListCustomMetricsResponse> {
    private final IotAsyncClient client;
    private final ListCustomMetricsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomMetricsPublisher(IotAsyncClient client, ListCustomMetricsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomMetricsPublisher(IotAsyncClient client, ListCustomMetricsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomMetricsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomMetricsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> metricNames() {
        Function<ListCustomMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricNames() != null) {
                return response.metricNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCustomMetricsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCustomMetricsResponseFetcher
    implements AsyncPageFetcher<ListCustomMetricsResponse> {
        private ListCustomMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomMetricsResponse> nextPage(ListCustomMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomMetricsPublisher.this.client.listCustomMetrics(ListCustomMetricsPublisher.this.firstRequest);
            }
            return ListCustomMetricsPublisher.this.client.listCustomMetrics((ListCustomMetricsRequest)((Object)ListCustomMetricsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

