/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesResponse;
import software.amazon.awssdk.services.iot.model.SecurityProfileIdentifier;

public class ListSecurityProfilesIterable
implements SdkIterable<ListSecurityProfilesResponse> {
    private final IotClient client;
    private final ListSecurityProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSecurityProfilesIterable(IotClient client, ListSecurityProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSecurityProfilesResponseFetcher();
    }

    public Iterator<ListSecurityProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecurityProfileIdentifier> securityProfileIdentifiers() {
        Function<ListSecurityProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityProfileIdentifiers() != null) {
                return response.securityProfileIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSecurityProfilesResponseFetcher
    implements SyncPageFetcher<ListSecurityProfilesResponse> {
        private ListSecurityProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSecurityProfilesResponse nextPage(ListSecurityProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityProfilesIterable.this.client.listSecurityProfiles(ListSecurityProfilesIterable.this.firstRequest);
            }
            return ListSecurityProfilesIterable.this.client.listSecurityProfiles((ListSecurityProfilesRequest)((Object)ListSecurityProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

