/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.CertificateStatus;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterCertificateRequest
extends IotRequest
implements ToCopyableBuilder<Builder, RegisterCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificatePem").getter(RegisterCertificateRequest.getter(RegisterCertificateRequest::certificatePem)).setter(RegisterCertificateRequest.setter(Builder::certificatePem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePem").build()}).build();
    private static final SdkField<String> CA_CERTIFICATE_PEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caCertificatePem").getter(RegisterCertificateRequest.getter(RegisterCertificateRequest::caCertificatePem)).setter(RegisterCertificateRequest.setter(Builder::caCertificatePem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caCertificatePem").build()}).build();
    private static final SdkField<Boolean> SET_AS_ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("setAsActive").getter(RegisterCertificateRequest.getter(RegisterCertificateRequest::setAsActive)).setter(RegisterCertificateRequest.setter(Builder::setAsActive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("setAsActive").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(RegisterCertificateRequest.getter(RegisterCertificateRequest::statusAsString)).setter(RegisterCertificateRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_PEM_FIELD, CA_CERTIFICATE_PEM_FIELD, SET_AS_ACTIVE_FIELD, STATUS_FIELD));
    private final String certificatePem;
    private final String caCertificatePem;
    private final Boolean setAsActive;
    private final String status;

    private RegisterCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificatePem = builder.certificatePem;
        this.caCertificatePem = builder.caCertificatePem;
        this.setAsActive = builder.setAsActive;
        this.status = builder.status;
    }

    public final String certificatePem() {
        return this.certificatePem;
    }

    public final String caCertificatePem() {
        return this.caCertificatePem;
    }

    @Deprecated
    public final Boolean setAsActive() {
        return this.setAsActive;
    }

    public final CertificateStatus status() {
        return CertificateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(this.setAsActive());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterCertificateRequest)) {
            return false;
        }
        RegisterCertificateRequest other = (RegisterCertificateRequest)((Object)obj);
        return Objects.equals(this.certificatePem(), other.certificatePem()) && Objects.equals(this.caCertificatePem(), other.caCertificatePem()) && Objects.equals(this.setAsActive(), other.setAsActive()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterCertificateRequest").add("CertificatePem", (Object)this.certificatePem()).add("CaCertificatePem", (Object)this.caCertificatePem()).add("SetAsActive", (Object)this.setAsActive()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificatePem": {
                return Optional.ofNullable(clazz.cast(this.certificatePem()));
            }
            case "caCertificatePem": {
                return Optional.ofNullable(clazz.cast(this.caCertificatePem()));
            }
            case "setAsActive": {
                return Optional.ofNullable(clazz.cast(this.setAsActive()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterCertificateRequest, T> g) {
        return obj -> g.apply((RegisterCertificateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String certificatePem;
        private String caCertificatePem;
        private Boolean setAsActive;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterCertificateRequest model) {
            super(model);
            this.certificatePem(model.certificatePem);
            this.caCertificatePem(model.caCertificatePem);
            this.setAsActive(model.setAsActive);
            this.status(model.status);
        }

        public final String getCertificatePem() {
            return this.certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final String getCaCertificatePem() {
            return this.caCertificatePem;
        }

        @Override
        public final Builder caCertificatePem(String caCertificatePem) {
            this.caCertificatePem = caCertificatePem;
            return this;
        }

        public final void setCaCertificatePem(String caCertificatePem) {
            this.caCertificatePem = caCertificatePem;
        }

        @Deprecated
        public final Boolean getSetAsActive() {
            return this.setAsActive;
        }

        @Override
        @Deprecated
        public final Builder setAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
            return this;
        }

        @Deprecated
        public final void setSetAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterCertificateRequest build() {
            return new RegisterCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterCertificateRequest> {
        public Builder certificatePem(String var1);

        public Builder caCertificatePem(String var1);

        @Deprecated
        public Builder setAsActive(Boolean var1);

        public Builder status(String var1);

        public Builder status(CertificateStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

