/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskStatisticsForAuditCheck
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskStatisticsForAuditCheck> {
    private static final SdkField<Long> TOTAL_FINDINGS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalFindingsCount").getter(TaskStatisticsForAuditCheck.getter(TaskStatisticsForAuditCheck::totalFindingsCount)).setter(TaskStatisticsForAuditCheck.setter(Builder::totalFindingsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalFindingsCount").build()}).build();
    private static final SdkField<Long> FAILED_FINDINGS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("failedFindingsCount").getter(TaskStatisticsForAuditCheck.getter(TaskStatisticsForAuditCheck::failedFindingsCount)).setter(TaskStatisticsForAuditCheck.setter(Builder::failedFindingsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedFindingsCount").build()}).build();
    private static final SdkField<Long> SUCCEEDED_FINDINGS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("succeededFindingsCount").getter(TaskStatisticsForAuditCheck.getter(TaskStatisticsForAuditCheck::succeededFindingsCount)).setter(TaskStatisticsForAuditCheck.setter(Builder::succeededFindingsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("succeededFindingsCount").build()}).build();
    private static final SdkField<Long> SKIPPED_FINDINGS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("skippedFindingsCount").getter(TaskStatisticsForAuditCheck.getter(TaskStatisticsForAuditCheck::skippedFindingsCount)).setter(TaskStatisticsForAuditCheck.setter(Builder::skippedFindingsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skippedFindingsCount").build()}).build();
    private static final SdkField<Long> CANCELED_FINDINGS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("canceledFindingsCount").getter(TaskStatisticsForAuditCheck.getter(TaskStatisticsForAuditCheck::canceledFindingsCount)).setter(TaskStatisticsForAuditCheck.setter(Builder::canceledFindingsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canceledFindingsCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FINDINGS_COUNT_FIELD, FAILED_FINDINGS_COUNT_FIELD, SUCCEEDED_FINDINGS_COUNT_FIELD, SKIPPED_FINDINGS_COUNT_FIELD, CANCELED_FINDINGS_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long totalFindingsCount;
    private final Long failedFindingsCount;
    private final Long succeededFindingsCount;
    private final Long skippedFindingsCount;
    private final Long canceledFindingsCount;

    private TaskStatisticsForAuditCheck(BuilderImpl builder) {
        this.totalFindingsCount = builder.totalFindingsCount;
        this.failedFindingsCount = builder.failedFindingsCount;
        this.succeededFindingsCount = builder.succeededFindingsCount;
        this.skippedFindingsCount = builder.skippedFindingsCount;
        this.canceledFindingsCount = builder.canceledFindingsCount;
    }

    public final Long totalFindingsCount() {
        return this.totalFindingsCount;
    }

    public final Long failedFindingsCount() {
        return this.failedFindingsCount;
    }

    public final Long succeededFindingsCount() {
        return this.succeededFindingsCount;
    }

    public final Long skippedFindingsCount() {
        return this.skippedFindingsCount;
    }

    public final Long canceledFindingsCount() {
        return this.canceledFindingsCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalFindingsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedFindingsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.succeededFindingsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.skippedFindingsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.canceledFindingsCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskStatisticsForAuditCheck)) {
            return false;
        }
        TaskStatisticsForAuditCheck other = (TaskStatisticsForAuditCheck)obj;
        return Objects.equals(this.totalFindingsCount(), other.totalFindingsCount()) && Objects.equals(this.failedFindingsCount(), other.failedFindingsCount()) && Objects.equals(this.succeededFindingsCount(), other.succeededFindingsCount()) && Objects.equals(this.skippedFindingsCount(), other.skippedFindingsCount()) && Objects.equals(this.canceledFindingsCount(), other.canceledFindingsCount());
    }

    public final String toString() {
        return ToString.builder((String)"TaskStatisticsForAuditCheck").add("TotalFindingsCount", (Object)this.totalFindingsCount()).add("FailedFindingsCount", (Object)this.failedFindingsCount()).add("SucceededFindingsCount", (Object)this.succeededFindingsCount()).add("SkippedFindingsCount", (Object)this.skippedFindingsCount()).add("CanceledFindingsCount", (Object)this.canceledFindingsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "totalFindingsCount": {
                return Optional.ofNullable(clazz.cast(this.totalFindingsCount()));
            }
            case "failedFindingsCount": {
                return Optional.ofNullable(clazz.cast(this.failedFindingsCount()));
            }
            case "succeededFindingsCount": {
                return Optional.ofNullable(clazz.cast(this.succeededFindingsCount()));
            }
            case "skippedFindingsCount": {
                return Optional.ofNullable(clazz.cast(this.skippedFindingsCount()));
            }
            case "canceledFindingsCount": {
                return Optional.ofNullable(clazz.cast(this.canceledFindingsCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskStatisticsForAuditCheck, T> g) {
        return obj -> g.apply((TaskStatisticsForAuditCheck)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long totalFindingsCount;
        private Long failedFindingsCount;
        private Long succeededFindingsCount;
        private Long skippedFindingsCount;
        private Long canceledFindingsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskStatisticsForAuditCheck model) {
            this.totalFindingsCount(model.totalFindingsCount);
            this.failedFindingsCount(model.failedFindingsCount);
            this.succeededFindingsCount(model.succeededFindingsCount);
            this.skippedFindingsCount(model.skippedFindingsCount);
            this.canceledFindingsCount(model.canceledFindingsCount);
        }

        public final Long getTotalFindingsCount() {
            return this.totalFindingsCount;
        }

        @Override
        public final Builder totalFindingsCount(Long totalFindingsCount) {
            this.totalFindingsCount = totalFindingsCount;
            return this;
        }

        public final void setTotalFindingsCount(Long totalFindingsCount) {
            this.totalFindingsCount = totalFindingsCount;
        }

        public final Long getFailedFindingsCount() {
            return this.failedFindingsCount;
        }

        @Override
        public final Builder failedFindingsCount(Long failedFindingsCount) {
            this.failedFindingsCount = failedFindingsCount;
            return this;
        }

        public final void setFailedFindingsCount(Long failedFindingsCount) {
            this.failedFindingsCount = failedFindingsCount;
        }

        public final Long getSucceededFindingsCount() {
            return this.succeededFindingsCount;
        }

        @Override
        public final Builder succeededFindingsCount(Long succeededFindingsCount) {
            this.succeededFindingsCount = succeededFindingsCount;
            return this;
        }

        public final void setSucceededFindingsCount(Long succeededFindingsCount) {
            this.succeededFindingsCount = succeededFindingsCount;
        }

        public final Long getSkippedFindingsCount() {
            return this.skippedFindingsCount;
        }

        @Override
        public final Builder skippedFindingsCount(Long skippedFindingsCount) {
            this.skippedFindingsCount = skippedFindingsCount;
            return this;
        }

        public final void setSkippedFindingsCount(Long skippedFindingsCount) {
            this.skippedFindingsCount = skippedFindingsCount;
        }

        public final Long getCanceledFindingsCount() {
            return this.canceledFindingsCount;
        }

        @Override
        public final Builder canceledFindingsCount(Long canceledFindingsCount) {
            this.canceledFindingsCount = canceledFindingsCount;
            return this;
        }

        public final void setCanceledFindingsCount(Long canceledFindingsCount) {
            this.canceledFindingsCount = canceledFindingsCount;
        }

        public TaskStatisticsForAuditCheck build() {
            return new TaskStatisticsForAuditCheck(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskStatisticsForAuditCheck> {
        public Builder totalFindingsCount(Long var1);

        public Builder failedFindingsCount(Long var1);

        public Builder succeededFindingsCount(Long var1);

        public Builder skippedFindingsCount(Long var1);

        public Builder canceledFindingsCount(Long var1);
    }
}

