/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsRequest;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsResponse;

public class ListThingPrincipalsIterable
implements SdkIterable<ListThingPrincipalsResponse> {
    private final IotClient client;
    private final ListThingPrincipalsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThingPrincipalsIterable(IotClient client, ListThingPrincipalsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListThingPrincipalsResponseFetcher();
    }

    public Iterator<ListThingPrincipalsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> principals() {
        Function<ListThingPrincipalsResponse, Iterator> getIterator = response -> {
            if (response != null && response.principals() != null) {
                return response.principals().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListThingPrincipalsResponseFetcher
    implements SyncPageFetcher<ListThingPrincipalsResponse> {
        private ListThingPrincipalsResponseFetcher() {
        }

        public boolean hasNextPage(ListThingPrincipalsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListThingPrincipalsResponse nextPage(ListThingPrincipalsResponse previousPage) {
            if (previousPage == null) {
                return ListThingPrincipalsIterable.this.client.listThingPrincipals(ListThingPrincipalsIterable.this.firstRequest);
            }
            return ListThingPrincipalsIterable.this.client.listThingPrincipals((ListThingPrincipalsRequest)((Object)ListThingPrincipalsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

