/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.AttributePayload;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateThingRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateThingRequest> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(CreateThingRequest.getter(CreateThingRequest::thingName)).setter(CreateThingRequest.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()}).build();
    private static final SdkField<String> THING_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingTypeName").getter(CreateThingRequest.getter(CreateThingRequest::thingTypeName)).setter(CreateThingRequest.setter(Builder::thingTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeName").build()}).build();
    private static final SdkField<AttributePayload> ATTRIBUTE_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attributePayload").getter(CreateThingRequest.getter(CreateThingRequest::attributePayload)).setter(CreateThingRequest.setter(Builder::attributePayload)).constructor(AttributePayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributePayload").build()}).build();
    private static final SdkField<String> BILLING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billingGroupName").getter(CreateThingRequest.getter(CreateThingRequest::billingGroupName)).setter(CreateThingRequest.setter(Builder::billingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD, THING_TYPE_NAME_FIELD, ATTRIBUTE_PAYLOAD_FIELD, BILLING_GROUP_NAME_FIELD));
    private final String thingName;
    private final String thingTypeName;
    private final AttributePayload attributePayload;
    private final String billingGroupName;

    private CreateThingRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.thingTypeName = builder.thingTypeName;
        this.attributePayload = builder.attributePayload;
        this.billingGroupName = builder.billingGroupName;
    }

    public final String thingName() {
        return this.thingName;
    }

    public final String thingTypeName() {
        return this.thingTypeName;
    }

    public final AttributePayload attributePayload() {
        return this.attributePayload;
    }

    public final String billingGroupName() {
        return this.billingGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributePayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingRequest)) {
            return false;
        }
        CreateThingRequest other = (CreateThingRequest)((Object)obj);
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.thingTypeName(), other.thingTypeName()) && Objects.equals(this.attributePayload(), other.attributePayload()) && Objects.equals(this.billingGroupName(), other.billingGroupName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateThingRequest").add("ThingName", (Object)this.thingName()).add("ThingTypeName", (Object)this.thingTypeName()).add("AttributePayload", (Object)this.attributePayload()).add("BillingGroupName", (Object)this.billingGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "thingTypeName": {
                return Optional.ofNullable(clazz.cast(this.thingTypeName()));
            }
            case "attributePayload": {
                return Optional.ofNullable(clazz.cast(this.attributePayload()));
            }
            case "billingGroupName": {
                return Optional.ofNullable(clazz.cast(this.billingGroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateThingRequest, T> g) {
        return obj -> g.apply((CreateThingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String thingName;
        private String thingTypeName;
        private AttributePayload attributePayload;
        private String billingGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingRequest model) {
            super(model);
            this.thingName(model.thingName);
            this.thingTypeName(model.thingTypeName);
            this.attributePayload(model.attributePayload);
            this.billingGroupName(model.billingGroupName);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final AttributePayload.Builder getAttributePayload() {
            return this.attributePayload != null ? this.attributePayload.toBuilder() : null;
        }

        @Override
        public final Builder attributePayload(AttributePayload attributePayload) {
            this.attributePayload = attributePayload;
            return this;
        }

        public final void setAttributePayload(AttributePayload.BuilderImpl attributePayload) {
            this.attributePayload = attributePayload != null ? attributePayload.build() : null;
        }

        public final String getBillingGroupName() {
            return this.billingGroupName;
        }

        @Override
        public final Builder billingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
            return this;
        }

        public final void setBillingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateThingRequest build() {
            return new CreateThingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateThingRequest> {
        public Builder thingName(String var1);

        public Builder thingTypeName(String var1);

        public Builder attributePayload(AttributePayload var1);

        default public Builder attributePayload(Consumer<AttributePayload.Builder> attributePayload) {
            return this.attributePayload((AttributePayload)((AttributePayload.Builder)AttributePayload.builder().applyMutation(attributePayload)).build());
        }

        public Builder billingGroupName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

