/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.GroupNameAndArn;
import software.amazon.awssdk.services.iot.model.ListThingGroupsForThingRequest;
import software.amazon.awssdk.services.iot.model.ListThingGroupsForThingResponse;

public class ListThingGroupsForThingIterable
implements SdkIterable<ListThingGroupsForThingResponse> {
    private final IotClient client;
    private final ListThingGroupsForThingRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThingGroupsForThingIterable(IotClient client, ListThingGroupsForThingRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListThingGroupsForThingResponseFetcher();
    }

    public Iterator<ListThingGroupsForThingResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GroupNameAndArn> thingGroups() {
        Function<ListThingGroupsForThingResponse, Iterator> getIterator = response -> {
            if (response != null && response.thingGroups() != null) {
                return response.thingGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListThingGroupsForThingResponseFetcher
    implements SyncPageFetcher<ListThingGroupsForThingResponse> {
        private ListThingGroupsForThingResponseFetcher() {
        }

        public boolean hasNextPage(ListThingGroupsForThingResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListThingGroupsForThingResponse nextPage(ListThingGroupsForThingResponse previousPage) {
            if (previousPage == null) {
                return ListThingGroupsForThingIterable.this.client.listThingGroupsForThing(ListThingGroupsForThingIterable.this.firstRequest);
            }
            return ListThingGroupsForThingIterable.this.client.listThingGroupsForThing((ListThingGroupsForThingRequest)((Object)ListThingGroupsForThingIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

