/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.GroupNameAndArn;
import software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest;
import software.amazon.awssdk.services.iot.model.ListBillingGroupsResponse;

public class ListBillingGroupsPublisher
implements SdkPublisher<ListBillingGroupsResponse> {
    private final IotAsyncClient client;
    private final ListBillingGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBillingGroupsPublisher(IotAsyncClient client, ListBillingGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBillingGroupsPublisher(IotAsyncClient client, ListBillingGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBillingGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBillingGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GroupNameAndArn> billingGroups() {
        Function<ListBillingGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.billingGroups() != null) {
                return response.billingGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBillingGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBillingGroupsResponseFetcher
    implements AsyncPageFetcher<ListBillingGroupsResponse> {
        private ListBillingGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillingGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBillingGroupsResponse> nextPage(ListBillingGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListBillingGroupsPublisher.this.client.listBillingGroups(ListBillingGroupsPublisher.this.firstRequest);
            }
            return ListBillingGroupsPublisher.this.client.listBillingGroups((ListBillingGroupsRequest)((Object)ListBillingGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

