/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.AuditMitigationActionsExecutionStatus;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAuditMitigationActionsExecutionsRequest
extends IotRequest
implements ToCopyableBuilder<Builder, ListAuditMitigationActionsExecutionsRequest> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(ListAuditMitigationActionsExecutionsRequest.getter(ListAuditMitigationActionsExecutionsRequest::taskId)).setter(ListAuditMitigationActionsExecutionsRequest.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("taskId").build()}).build();
    private static final SdkField<String> ACTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionStatus").getter(ListAuditMitigationActionsExecutionsRequest.getter(ListAuditMitigationActionsExecutionsRequest::actionStatusAsString)).setter(ListAuditMitigationActionsExecutionsRequest.setter(Builder::actionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("actionStatus").build()}).build();
    private static final SdkField<String> FINDING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingId").getter(ListAuditMitigationActionsExecutionsRequest.getter(ListAuditMitigationActionsExecutionsRequest::findingId)).setter(ListAuditMitigationActionsExecutionsRequest.setter(Builder::findingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("findingId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAuditMitigationActionsExecutionsRequest.getter(ListAuditMitigationActionsExecutionsRequest::maxResults)).setter(ListAuditMitigationActionsExecutionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAuditMitigationActionsExecutionsRequest.getter(ListAuditMitigationActionsExecutionsRequest::nextToken)).setter(ListAuditMitigationActionsExecutionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, ACTION_STATUS_FIELD, FINDING_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String taskId;
    private final String actionStatus;
    private final String findingId;
    private final Integer maxResults;
    private final String nextToken;

    private ListAuditMitigationActionsExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.actionStatus = builder.actionStatus;
        this.findingId = builder.findingId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final AuditMitigationActionsExecutionStatus actionStatus() {
        return AuditMitigationActionsExecutionStatus.fromValue(this.actionStatus);
    }

    public final String actionStatusAsString() {
        return this.actionStatus;
    }

    public final String findingId() {
        return this.findingId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditMitigationActionsExecutionsRequest)) {
            return false;
        }
        ListAuditMitigationActionsExecutionsRequest other = (ListAuditMitigationActionsExecutionsRequest)((Object)obj);
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.actionStatusAsString(), other.actionStatusAsString()) && Objects.equals(this.findingId(), other.findingId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAuditMitigationActionsExecutionsRequest").add("TaskId", (Object)this.taskId()).add("ActionStatus", (Object)this.actionStatusAsString()).add("FindingId", (Object)this.findingId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "actionStatus": {
                return Optional.ofNullable(clazz.cast(this.actionStatusAsString()));
            }
            case "findingId": {
                return Optional.ofNullable(clazz.cast(this.findingId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAuditMitigationActionsExecutionsRequest, T> g) {
        return obj -> g.apply((ListAuditMitigationActionsExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String taskId;
        private String actionStatus;
        private String findingId;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditMitigationActionsExecutionsRequest model) {
            super(model);
            this.taskId(model.taskId);
            this.actionStatus(model.actionStatus);
            this.findingId(model.findingId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getActionStatus() {
            return this.actionStatus;
        }

        @Override
        public final Builder actionStatus(String actionStatus) {
            this.actionStatus = actionStatus;
            return this;
        }

        @Override
        public final Builder actionStatus(AuditMitigationActionsExecutionStatus actionStatus) {
            this.actionStatus(actionStatus == null ? null : actionStatus.toString());
            return this;
        }

        public final void setActionStatus(String actionStatus) {
            this.actionStatus = actionStatus;
        }

        public final String getFindingId() {
            return this.findingId;
        }

        @Override
        public final Builder findingId(String findingId) {
            this.findingId = findingId;
            return this;
        }

        public final void setFindingId(String findingId) {
            this.findingId = findingId;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAuditMitigationActionsExecutionsRequest build() {
            return new ListAuditMitigationActionsExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAuditMitigationActionsExecutionsRequest> {
        public Builder taskId(String var1);

        public Builder actionStatus(String var1);

        public Builder actionStatus(AuditMitigationActionsExecutionStatus var1);

        public Builder findingId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

