/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IndexStatus;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIndexResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeIndexResponse> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexName").getter(DescribeIndexResponse.getter(DescribeIndexResponse::indexName)).setter(DescribeIndexResponse.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()}).build();
    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexStatus").getter(DescribeIndexResponse.getter(DescribeIndexResponse::indexStatusAsString)).setter(DescribeIndexResponse.setter(Builder::indexStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexStatus").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schema").getter(DescribeIndexResponse.getter(DescribeIndexResponse::schema)).setter(DescribeIndexResponse.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD, INDEX_STATUS_FIELD, SCHEMA_FIELD));
    private final String indexName;
    private final String indexStatus;
    private final String schema;

    private DescribeIndexResponse(BuilderImpl builder) {
        super(builder);
        this.indexName = builder.indexName;
        this.indexStatus = builder.indexStatus;
        this.schema = builder.schema;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final IndexStatus indexStatus() {
        return IndexStatus.fromValue(this.indexStatus);
    }

    public final String indexStatusAsString() {
        return this.indexStatus;
    }

    public final String schema() {
        return this.schema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIndexResponse)) {
            return false;
        }
        DescribeIndexResponse other = (DescribeIndexResponse)((Object)obj);
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.indexStatusAsString(), other.indexStatusAsString()) && Objects.equals(this.schema(), other.schema());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIndexResponse").add("IndexName", (Object)this.indexName()).add("IndexStatus", (Object)this.indexStatusAsString()).add("Schema", (Object)this.schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "indexStatus": {
                return Optional.ofNullable(clazz.cast(this.indexStatusAsString()));
            }
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIndexResponse, T> g) {
        return obj -> g.apply((DescribeIndexResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String indexName;
        private String indexStatus;
        private String schema;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIndexResponse model) {
            super(model);
            this.indexName(model.indexName);
            this.indexStatus(model.indexStatus);
            this.schema(model.schema);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getIndexStatus() {
            return this.indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        public final String getSchema() {
            return this.schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public DescribeIndexResponse build() {
            return new DescribeIndexResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIndexResponse> {
        public Builder indexName(String var1);

        public Builder indexStatus(String var1);

        public Builder indexStatus(IndexStatus var1);

        public Builder schema(String var1);
    }
}

