/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchIndexResponse extends IotResponse implements
        ToCopyableBuilder<SearchIndexResponse.Builder, SearchIndexResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchIndexResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ThingDocument>> THINGS_FIELD = SdkField
            .<List<ThingDocument>> builder(MarshallingType.LIST)
            .memberName("things")
            .getter(getter(SearchIndexResponse::things))
            .setter(setter(Builder::things))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("things").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThingDocument> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThingDocument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ThingGroupDocument>> THING_GROUPS_FIELD = SdkField
            .<List<ThingGroupDocument>> builder(MarshallingType.LIST)
            .memberName("thingGroups")
            .getter(getter(SearchIndexResponse::thingGroups))
            .setter(setter(Builder::thingGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThingGroupDocument> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThingGroupDocument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            THINGS_FIELD, THING_GROUPS_FIELD));

    private final String nextToken;

    private final List<ThingDocument> things;

    private final List<ThingGroupDocument> thingGroups;

    private SearchIndexResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.things = builder.things;
        this.thingGroups = builder.thingGroups;
    }

    /**
     * <p>
     * The token used to get the next set of results, or <code>null</code> if there are no additional results.
     * </p>
     * 
     * @return The token used to get the next set of results, or <code>null</code> if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Things property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasThings() {
        return things != null && !(things instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The things that match the search query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The things that match the search query.
     */
    public final List<ThingDocument> things() {
        return things;
    }

    /**
     * Returns true if the ThingGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasThingGroups() {
        return thingGroups != null && !(thingGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The thing groups that match the search query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThingGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The thing groups that match the search query.
     */
    public final List<ThingGroupDocument> thingGroups() {
        return thingGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasThings() ? things() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasThingGroups() ? thingGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchIndexResponse)) {
            return false;
        }
        SearchIndexResponse other = (SearchIndexResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasThings() == other.hasThings()
                && Objects.equals(things(), other.things()) && hasThingGroups() == other.hasThingGroups()
                && Objects.equals(thingGroups(), other.thingGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchIndexResponse").add("NextToken", nextToken()).add("Things", hasThings() ? things() : null)
                .add("ThingGroups", hasThingGroups() ? thingGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "things":
            return Optional.ofNullable(clazz.cast(things()));
        case "thingGroups":
            return Optional.ofNullable(clazz.cast(thingGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchIndexResponse, T> g) {
        return obj -> g.apply((SearchIndexResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchIndexResponse> {
        /**
         * <p>
         * The token used to get the next set of results, or <code>null</code> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token used to get the next set of results, or <code>null</code> if there are no additional
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The things that match the search query.
         * </p>
         * 
         * @param things
         *        The things that match the search query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder things(Collection<ThingDocument> things);

        /**
         * <p>
         * The things that match the search query.
         * </p>
         * 
         * @param things
         *        The things that match the search query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder things(ThingDocument... things);

        /**
         * <p>
         * The things that match the search query.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ThingDocument>.Builder} avoiding the need
         * to create one manually via {@link List<ThingDocument>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ThingDocument>.Builder#build()} is called immediately and
         * its result is passed to {@link #things(List<ThingDocument>)}.
         * 
         * @param things
         *        a consumer that will call methods on {@link List<ThingDocument>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #things(List<ThingDocument>)
         */
        Builder things(Consumer<ThingDocument.Builder>... things);

        /**
         * <p>
         * The thing groups that match the search query.
         * </p>
         * 
         * @param thingGroups
         *        The thing groups that match the search query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroups(Collection<ThingGroupDocument> thingGroups);

        /**
         * <p>
         * The thing groups that match the search query.
         * </p>
         * 
         * @param thingGroups
         *        The thing groups that match the search query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroups(ThingGroupDocument... thingGroups);

        /**
         * <p>
         * The thing groups that match the search query.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ThingGroupDocument>.Builder} avoiding the
         * need to create one manually via {@link List<ThingGroupDocument>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ThingGroupDocument>.Builder#build()} is called immediately
         * and its result is passed to {@link #thingGroups(List<ThingGroupDocument>)}.
         * 
         * @param thingGroups
         *        a consumer that will call methods on {@link List<ThingGroupDocument>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingGroups(List<ThingGroupDocument>)
         */
        Builder thingGroups(Consumer<ThingGroupDocument.Builder>... thingGroups);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ThingDocument> things = DefaultSdkAutoConstructList.getInstance();

        private List<ThingGroupDocument> thingGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchIndexResponse model) {
            super(model);
            nextToken(model.nextToken);
            things(model.things);
            thingGroups(model.thingGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ThingDocument.Builder> getThings() {
            if (things instanceof SdkAutoConstructList) {
                return null;
            }
            return things != null ? things.stream().map(ThingDocument::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder things(Collection<ThingDocument> things) {
            this.things = ThingDocumentListCopier.copy(things);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(ThingDocument... things) {
            things(Arrays.asList(things));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(Consumer<ThingDocument.Builder>... things) {
            things(Stream.of(things).map(c -> ThingDocument.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setThings(Collection<ThingDocument.BuilderImpl> things) {
            this.things = ThingDocumentListCopier.copyFromBuilder(things);
        }

        public final Collection<ThingGroupDocument.Builder> getThingGroups() {
            if (thingGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return thingGroups != null ? thingGroups.stream().map(ThingGroupDocument::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder thingGroups(Collection<ThingGroupDocument> thingGroups) {
            this.thingGroups = ThingGroupDocumentListCopier.copy(thingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroups(ThingGroupDocument... thingGroups) {
            thingGroups(Arrays.asList(thingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroups(Consumer<ThingGroupDocument.Builder>... thingGroups) {
            thingGroups(Stream.of(thingGroups).map(c -> ThingGroupDocument.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setThingGroups(Collection<ThingGroupDocument.BuilderImpl> thingGroups) {
            this.thingGroups = ThingGroupDocumentListCopier.copyFromBuilder(thingGroups);
        }

        @Override
        public SearchIndexResponse build() {
            return new SearchIndexResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
