/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListThingGroupsForThingResponse extends IotResponse implements
        ToCopyableBuilder<ListThingGroupsForThingResponse.Builder, ListThingGroupsForThingResponse> {
    private static final SdkField<List<GroupNameAndArn>> THING_GROUPS_FIELD = SdkField
            .<List<GroupNameAndArn>> builder(MarshallingType.LIST)
            .memberName("thingGroups")
            .getter(getter(ListThingGroupsForThingResponse::thingGroups))
            .setter(setter(Builder::thingGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupNameAndArn> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupNameAndArn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListThingGroupsForThingResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<GroupNameAndArn> thingGroups;

    private final String nextToken;

    private ListThingGroupsForThingResponse(BuilderImpl builder) {
        super(builder);
        this.thingGroups = builder.thingGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ThingGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasThingGroups() {
        return thingGroups != null && !(thingGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The thing groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThingGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The thing groups.
     */
    public final List<GroupNameAndArn> thingGroups() {
        return thingGroups;
    }

    /**
     * <p>
     * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasThingGroups() ? thingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingGroupsForThingResponse)) {
            return false;
        }
        ListThingGroupsForThingResponse other = (ListThingGroupsForThingResponse) obj;
        return hasThingGroups() == other.hasThingGroups() && Objects.equals(thingGroups(), other.thingGroups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListThingGroupsForThingResponse").add("ThingGroups", hasThingGroups() ? thingGroups() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroups":
            return Optional.ofNullable(clazz.cast(thingGroups()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListThingGroupsForThingResponse, T> g) {
        return obj -> g.apply((ListThingGroupsForThingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListThingGroupsForThingResponse> {
        /**
         * <p>
         * The thing groups.
         * </p>
         * 
         * @param thingGroups
         *        The thing groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroups(Collection<GroupNameAndArn> thingGroups);

        /**
         * <p>
         * The thing groups.
         * </p>
         * 
         * @param thingGroups
         *        The thing groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroups(GroupNameAndArn... thingGroups);

        /**
         * <p>
         * The thing groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GroupNameAndArn>.Builder} avoiding the need
         * to create one manually via {@link List<GroupNameAndArn>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupNameAndArn>.Builder#build()} is called immediately and
         * its result is passed to {@link #thingGroups(List<GroupNameAndArn>)}.
         * 
         * @param thingGroups
         *        a consumer that will call methods on {@link List<GroupNameAndArn>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingGroups(List<GroupNameAndArn>)
         */
        Builder thingGroups(Consumer<GroupNameAndArn.Builder>... thingGroups);

        /**
         * <p>
         * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<GroupNameAndArn> thingGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingGroupsForThingResponse model) {
            super(model);
            thingGroups(model.thingGroups);
            nextToken(model.nextToken);
        }

        public final Collection<GroupNameAndArn.Builder> getThingGroups() {
            if (thingGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return thingGroups != null ? thingGroups.stream().map(GroupNameAndArn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder thingGroups(Collection<GroupNameAndArn> thingGroups) {
            this.thingGroups = ThingGroupNameAndArnListCopier.copy(thingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroups(GroupNameAndArn... thingGroups) {
            thingGroups(Arrays.asList(thingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroups(Consumer<GroupNameAndArn.Builder>... thingGroups) {
            thingGroups(Stream.of(thingGroups).map(c -> GroupNameAndArn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setThingGroups(Collection<GroupNameAndArn.BuilderImpl> thingGroups) {
            this.thingGroups = ThingGroupNameAndArnListCopier.copyFromBuilder(thingGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListThingGroupsForThingResponse build() {
            return new ListThingGroupsForThingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
